"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSecurityV2BaseKibanaFeature = void 0;
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/features-plugin/common");
var _coreApplicationCommon = require("@kbn/core-application-common");
var _securitysolutionRules = require("@kbn/securitysolution-rules");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SECURITY_RULE_TYPES = [_constants.LEGACY_NOTIFICATIONS_ID, _securitysolutionRules.ESQL_RULE_TYPE_ID, _securitysolutionRules.EQL_RULE_TYPE_ID, _securitysolutionRules.INDICATOR_RULE_TYPE_ID, _securitysolutionRules.ML_RULE_TYPE_ID, _securitysolutionRules.QUERY_RULE_TYPE_ID, _securitysolutionRules.SAVED_QUERY_RULE_TYPE_ID, _securitysolutionRules.THRESHOLD_RULE_TYPE_ID, _securitysolutionRules.NEW_TERMS_RULE_TYPE_ID];
const alertingFeatures = SECURITY_RULE_TYPES.map(ruleTypeId => ({
  ruleTypeId,
  consumers: [_constants.SERVER_APP_ID]
}));
const getSecurityV2BaseKibanaFeature = ({
  savedObjects
}) => ({
  id: _constants.SECURITY_FEATURE_ID_V2,
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.linkSecuritySolutionTitle', {
    defaultMessage: 'Security'
  }),
  order: 1100,
  category: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security,
  scope: [_common.KibanaFeatureScope.Spaces, _common.KibanaFeatureScope.Security],
  app: [_constants.APP_ID, _constants.CLOUD_POSTURE_APP_ID, _constants.CLOUD_DEFEND_APP_ID, 'kibana'],
  catalogue: [_constants.APP_ID],
  management: {
    insightsAndAlerting: ['triggersActions']
  },
  alerting: alertingFeatures,
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.securityGroupDescription', {
    defaultMessage: "Each sub-feature privilege in this group must be assigned individually. Global assignment is only supported if your pricing plan doesn't allow individual feature privileges."
  }),
  privileges: {
    all: {
      app: [_constants.APP_ID, _constants.CLOUD_POSTURE_APP_ID, _constants.CLOUD_DEFEND_APP_ID, 'kibana'],
      catalogue: [_constants.APP_ID],
      api: [_constants.APP_ID, 'rac', 'lists-all', 'lists-read', 'lists-summary'],
      savedObject: {
        all: ['alert', ...savedObjects],
        read: []
      },
      alerting: {
        rule: {
          all: alertingFeatures
        },
        alert: {
          all: alertingFeatures
        }
      },
      management: {
        insightsAndAlerting: ['triggersActions']
      },
      ui: ['show', 'crud']
    },
    read: {
      app: [_constants.APP_ID, _constants.CLOUD_POSTURE_APP_ID, _constants.CLOUD_DEFEND_APP_ID, 'kibana'],
      catalogue: [_constants.APP_ID],
      api: [_constants.APP_ID, 'rac', 'lists-read'],
      savedObject: {
        all: [],
        read: [...savedObjects]
      },
      alerting: {
        rule: {
          read: alertingFeatures
        },
        alert: {
          all: alertingFeatures
        }
      },
      management: {
        insightsAndAlerting: ['triggersActions']
      },
      ui: ['show']
    }
  }
});
exports.getSecurityV2BaseKibanaFeature = getSecurityV2BaseKibanaFeature;