"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCasesBaseKibanaFeature = void 0;
var _i18n = require("@kbn/i18n");
var _coreApplicationCommon = require("@kbn/core-application-common");
var _common = require("@kbn/features-plugin/common");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * @deprecated Use getCasesBaseKibanaFeatureV2 instead
 */
const getCasesBaseKibanaFeature = ({
  uiCapabilities,
  apiTags,
  savedObjects
}) => {
  return {
    deprecated: {
      notice: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.linkSecuritySolutionCase.deprecationMessage', {
        defaultMessage: 'The {currentId} permissions are deprecated, please see {casesFeatureIdV2}.',
        values: {
          currentId: _constants.CASES_FEATURE_ID,
          casesFeatureIdV2: _constants.CASES_FEATURE_ID_V3
        }
      })
    },
    id: _constants.CASES_FEATURE_ID,
    name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.linkSecuritySolutionCaseTitleDeprecated', {
      defaultMessage: 'Cases (Deprecated)'
    }),
    order: 1200,
    category: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security,
    scope: [_common.KibanaFeatureScope.Spaces, _common.KibanaFeatureScope.Security],
    app: [_constants.CASES_FEATURE_ID, 'kibana'],
    catalogue: [_constants.APP_ID],
    cases: [_constants.APP_ID],
    privileges: {
      all: {
        api: [...apiTags.all, ...apiTags.createComment],
        app: [_constants.CASES_FEATURE_ID, 'kibana'],
        catalogue: [_constants.APP_ID],
        cases: {
          create: [_constants.APP_ID],
          read: [_constants.APP_ID],
          update: [_constants.APP_ID],
          push: [_constants.APP_ID],
          createComment: [_constants.APP_ID],
          reopenCase: [_constants.APP_ID],
          assign: [_constants.APP_ID]
        },
        savedObject: {
          all: [...savedObjects.files],
          read: [...savedObjects.files]
        },
        ui: [...uiCapabilities.all, ...uiCapabilities.createComment, ...uiCapabilities.reopenCase, ...uiCapabilities.assignCase],
        replacedBy: {
          default: [{
            feature: _constants.CASES_FEATURE_ID_V3,
            privileges: ['all']
          }],
          minimal: [{
            feature: _constants.CASES_FEATURE_ID_V3,
            privileges: ['minimal_all', 'create_comment', 'case_reopen', 'cases_assign']
          }]
        }
      },
      read: {
        api: apiTags.read,
        app: [_constants.CASES_FEATURE_ID, 'kibana'],
        catalogue: [_constants.APP_ID],
        cases: {
          read: [_constants.APP_ID]
        },
        savedObject: {
          all: [],
          read: [...savedObjects.files]
        },
        ui: uiCapabilities.read,
        replacedBy: {
          default: [{
            feature: _constants.CASES_FEATURE_ID_V3,
            privileges: ['read']
          }],
          minimal: [{
            feature: _constants.CASES_FEATURE_ID_V3,
            privileges: ['minimal_read']
          }]
        }
      }
    }
  };
};
exports.getCasesBaseKibanaFeature = getCasesBaseKibanaFeature;