"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineRolesRoutes = defineRolesRoutes;
var _delete = require("./delete");
var _get = require("./get");
var _get_all = require("./get_all");
var _get_all_by_space = require("./get_all_by_space");
var _post = require("./post");
var _put = require("./put");
var _query = require("./query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function defineRolesRoutes(params) {
  (0, _get.defineGetRolesRoutes)(params);
  (0, _get_all.defineGetAllRolesRoutes)(params);
  (0, _delete.defineDeleteRolesRoutes)(params);
  (0, _put.definePutRolesRoutes)(params);
  (0, _get_all_by_space.defineGetAllRolesBySpaceRoutes)(params);
  (0, _post.defineBulkCreateOrUpdateRolesRoutes)(params);
  (0, _query.defineQueryRolesRoutes)(params);
}