"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSessionExpirationToast = exports.SessionExpirationToast = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _useAsyncFn = _interopRequireDefault(require("react-use/lib/useAsyncFn"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SessionExpirationToast = ({
  sessionState$,
  onExtend
}) => {
  const state = (0, _useObservable.default)(sessionState$);
  const [{
    loading
  }, extend] = (0, _useAsyncFn.default)(onExtend);
  if (!state || !state.expiresInMs) {
    return null;
  }
  const timeoutSeconds = Math.max(state.expiresInMs - _constants.SESSION_GRACE_PERIOD_MS, 0) / 1000;
  const expirationWarning = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.sessionExpirationToast.body",
    defaultMessage: "You will be logged out {timeout}.",
    values: {
      timeout: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelativeTime, {
        value: timeoutSeconds,
        updateIntervalInSeconds: 1
      })
    }
  });
  if (state.canBeExtended) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, expirationWarning, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      color: "warning",
      isLoading: loading,
      onClick: extend
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.sessionExpirationToast.extendButton",
      defaultMessage: "Stay logged in"
    })))));
  }
  return expirationWarning;
};
exports.SessionExpirationToast = SessionExpirationToast;
const createSessionExpirationToast = (services, sessionState$, onExtend, onClose) => {
  return {
    color: 'warning',
    iconType: 'clock',
    title: _i18n.i18n.translate('xpack.security.sessionExpirationToast.title', {
      defaultMessage: 'Session timeout'
    }),
    text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(SessionExpirationToast, {
      sessionState$: sessionState$,
      onExtend: onExtend
    }), services),
    onClose,
    toastLifeTimeMs: 0x7fffffff // Toast is hidden based on observable so using maximum possible timeout
  };
};
exports.createSessionExpirationToast = createSessionExpirationToast;