"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecurityPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _account_management = require("./account_management");
var _analytics = require("./analytics");
var _anonymous_access = require("./anonymous_access");
var _authentication = require("./authentication");
var _authorization = require("./authorization");
var _build_delegate_api = require("./build_delegate_api");
var _management = require("./management");
var _nav_control = require("./nav_control");
var _security_checkup = require("./security_checkup");
var _session = require("./session");
var _ui_api = require("./ui_api");
var _licensing = require("../common/licensing");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SecurityPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "sessionTimeout", void 0);
    (0, _defineProperty2.default)(this, "authenticationService", new _authentication.AuthenticationService());
    (0, _defineProperty2.default)(this, "authorizationService", new _authorization.AuthorizationService());
    (0, _defineProperty2.default)(this, "navControlService", void 0);
    (0, _defineProperty2.default)(this, "securityLicenseService", new _licensing.SecurityLicenseService());
    (0, _defineProperty2.default)(this, "managementService", void 0);
    (0, _defineProperty2.default)(this, "securityCheckupService", void 0);
    (0, _defineProperty2.default)(this, "anonymousAccessService", new _anonymous_access.AnonymousAccessService());
    (0, _defineProperty2.default)(this, "analyticsService", new _analytics.AnalyticsService());
    (0, _defineProperty2.default)(this, "authc", void 0);
    (0, _defineProperty2.default)(this, "authz", void 0);
    (0, _defineProperty2.default)(this, "securityApiClients", void 0);
    (0, _defineProperty2.default)(this, "buildFlavor", void 0);
    this.initializerContext = initializerContext;
    this.buildFlavor = initializerContext.env.packageInfo.buildFlavor;
    this.config = this.initializerContext.config.get();
    this.securityCheckupService = new _security_checkup.SecurityCheckupService(this.config, localStorage);
    this.navControlService = new _nav_control.SecurityNavControlService(this.buildFlavor);
    this.managementService = new _management.ManagementService(this.config);
  }
  setup(core, {
    cloud,
    home,
    licensing,
    management,
    share
  }) {
    const {
      license
    } = this.securityLicenseService.setup({
      license$: licensing.license$
    });
    this.securityCheckupService.setup({
      http: core.http
    });
    this.authc = this.authenticationService.setup({
      application: core.application,
      fatalErrors: core.fatalErrors,
      config: this.config,
      getStartServices: core.getStartServices,
      http: core.http
    });
    this.authz = this.authorizationService.setup({
      config: this.config,
      http: core.http
    });
    this.securityApiClients = {
      userProfiles: new _account_management.UserProfileAPIClient(core.http),
      users: new _management.UserAPIClient(core.http)
    };
    this.navControlService.setup({
      securityLicense: license,
      logoutUrl: getLogoutUrl(core.http),
      securityApiClients: this.securityApiClients
    });
    this.analyticsService.setup({
      analytics: core.analytics,
      authc: this.authc,
      cloudId: cloud === null || cloud === void 0 ? void 0 : cloud.cloudId,
      http: core.http,
      securityLicense: license
    });
    _account_management.accountManagementApp.create({
      authc: this.authc,
      application: core.application,
      getStartServices: core.getStartServices,
      securityApiClients: this.securityApiClients
    });
    core.security.registerSecurityDelegate((0, _build_delegate_api.buildSecurityApi)({
      authc: this.authc
    }));
    core.userProfile.registerUserProfileDelegate((0, _build_delegate_api.buildUserProfileApi)({
      userProfile: this.securityApiClients.userProfiles
    }));
    if (management) {
      this.managementService.setup({
        license,
        management,
        authc: this.authc,
        fatalErrors: core.fatalErrors,
        getStartServices: core.getStartServices,
        buildFlavor: this.buildFlavor
      });
    }
    if (management && home) {
      home.featureCatalogue.register({
        id: 'security',
        title: _i18n.i18n.translate('xpack.security.registerFeature.securitySettingsTitle', {
          defaultMessage: 'Manage permissions'
        }),
        description: _i18n.i18n.translate('xpack.security.registerFeature.securitySettingsDescription', {
          defaultMessage: 'Control who has access and what tasks they can perform.'
        }),
        icon: 'securityApp',
        path: '/app/management/security/roles',
        showOnHomePage: true,
        category: 'admin',
        order: 600
      });
    }
    if (share) {
      this.anonymousAccessService.setup({
        share
      });
    }
    return {
      authc: this.authc,
      authz: this.authz,
      license
    };
  }
  start(core, {
    management,
    share
  }) {
    const {
      application,
      http,
      notifications
    } = core;
    const {
      anonymousPaths
    } = http;
    const logoutUrl = getLogoutUrl(http);
    const tenant = http.basePath.serverBasePath;
    const sessionExpired = new _session.SessionExpired(application, logoutUrl, tenant);
    http.intercept(new _session.UnauthorizedResponseHttpInterceptor(sessionExpired, anonymousPaths));
    this.sessionTimeout = new _session.SessionTimeout(core, notifications, sessionExpired, http, tenant);
    this.sessionTimeout.start();
    this.securityCheckupService.start(core);
    this.securityApiClients.userProfiles.start();
    if (management) {
      this.managementService.start({
        capabilities: application.capabilities
      });
    }
    if (share) {
      this.anonymousAccessService.start({
        http
      });
    }
    this.analyticsService.start({
      http: core.http
    });
    return {
      uiApi: (0, _ui_api.getUiApi)({
        core
      }),
      navControlService: this.navControlService.start({
        core,
        authc: this.authc
      }),
      authc: this.authc,
      authz: this.authz,
      userProfiles: {
        getCurrent: this.securityApiClients.userProfiles.getCurrent.bind(this.securityApiClients.userProfiles),
        bulkGet: this.securityApiClients.userProfiles.bulkGet.bind(this.securityApiClients.userProfiles),
        suggest: this.securityApiClients.userProfiles.suggest.bind(this.securityApiClients.userProfiles),
        update: this.securityApiClients.userProfiles.update.bind(this.securityApiClients.userProfiles),
        partialUpdate: this.securityApiClients.userProfiles.partialUpdate.bind(this.securityApiClients.userProfiles),
        userProfile$: this.securityApiClients.userProfiles.userProfile$,
        userProfileLoaded$: this.securityApiClients.userProfiles.userProfileLoaded$,
        enabled$: this.securityApiClients.userProfiles.enabled$
      }
    };
  }
  stop() {
    var _this$sessionTimeout;
    (_this$sessionTimeout = this.sessionTimeout) === null || _this$sessionTimeout === void 0 ? void 0 : _this$sessionTimeout.stop();
    this.navControlService.stop();
    this.securityLicenseService.stop();
    this.managementService.stop();
    this.analyticsService.stop();
  }
}
exports.SecurityPlugin = SecurityPlugin;
function getLogoutUrl(http) {
  return `${http.basePath.serverBasePath}/logout`;
}