"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditUserPage = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _useAsyncFn = _interopRequireDefault(require("react-use/lib/useAsyncFn"));
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _change_password_modal = require("./change_password_modal");
var _confirm_delete_users = require("./confirm_delete_users");
var _confirm_disable_users = require("./confirm_disable_users");
var _confirm_enable_users = require("./confirm_enable_users");
var _user_form = require("./user_form");
var _model = require("../../../../common/model");
var _use_capabilities = require("../../../components/use_capabilities");
var _user_api_client = require("../user_api_client");
var _user_utils = require("../user_utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditUserPage = ({
  username
}) => {
  var _user$metadata, _user$metadata$_depre;
  const {
    services
  } = (0, _public.useKibana)();
  const history = (0, _reactRouterDom.useHistory)();
  const [{
    value: user,
    error
  }, getUser] = (0, _useAsyncFn.default)(() => new _user_api_client.UserAPIClient(services.http).getUser(username), [services.http]);
  const [action, setAction] = (0, _react.useState)('none');
  const readOnly = !(0, _use_capabilities.useCapabilities)('users').save;
  const backToUsers = () => history.push('/');
  (0, _react.useEffect)(() => {
    getUser();
  }, []); // eslint-disable-line react-hooks/exhaustive-deps

  (0, _react.useEffect)(() => {
    if (error) {
      backToUsers();
    }
  }, [error]); // eslint-disable-line react-hooks/exhaustive-deps

  if (!user) {
    return null;
  }
  const isReservedUser = (0, _user_utils.isUserReserved)(user);
  const isDeprecatedUser = (0, _user_utils.isUserDeprecated)(user);

  // We render email below the title already and don't need to duplicate it in the title itself.
  const title = (0, _model.getUserDisplayName)({
    full_name: user.full_name,
    username: user.username
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    bottomBorder: true,
    pageTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
      name: (0, _model.getUserDisplayName)(user),
      size: "xl"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h1", null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, user.email)))
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), isDeprecatedUser ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.users.editUserPage.deprecatedUserWarning",
      defaultMessage: "This user is deprecated."
    }),
    iconType: "warning",
    color: "warning"
  }, (_user$metadata = user.metadata) === null || _user$metadata === void 0 ? void 0 : (_user$metadata$_depre = _user$metadata._deprecated_reason) === null || _user$metadata$_depre === void 0 ? void 0 : _user$metadata$_depre.replace(/\[(.+)\]/, "'$1'")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : isReservedUser ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.users.editUserPage.reservedUserWarning",
      defaultMessage: "This user is built in and can't be updated or deleted."
    }),
    iconType: "lock"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : user.enabled === false ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.users.editUserPage.disabledUserWarning",
      defaultMessage: "This user has been deactivated and can't access Elastic."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => setAction('enableUser'),
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.users.editUserPage.enableUserButton",
    defaultMessage: "Activate user"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : undefined, /*#__PURE__*/_react.default.createElement(_user_form.UserForm, {
    isReservedUser: isReservedUser,
    defaultValues: user,
    onCancel: backToUsers,
    onSuccess: backToUsers,
    disabled: readOnly
  }), readOnly ? undefined : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, action === 'changePassword' ? /*#__PURE__*/_react.default.createElement(_change_password_modal.ChangePasswordModal, {
    username: username,
    onCancel: () => setAction('none'),
    onSuccess: () => setAction('none')
  }) : action === 'disableUser' ? /*#__PURE__*/_react.default.createElement(_confirm_disable_users.ConfirmDisableUsers, {
    usernames: [username],
    onCancel: () => setAction('none'),
    onSuccess: () => {
      setAction('none');
      getUser();
    }
  }) : action === 'enableUser' ? /*#__PURE__*/_react.default.createElement(_confirm_enable_users.ConfirmEnableUsers, {
    usernames: [username],
    onCancel: () => setAction('none'),
    onSuccess: () => {
      setAction('none');
      getUser();
    }
  }) : action === 'deleteUser' ? /*#__PURE__*/_react.default.createElement(_confirm_delete_users.ConfirmDeleteUsers, {
    usernames: [username],
    onCancel: () => setAction('none'),
    onSuccess: backToUsers
  }) : undefined, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    hasShadow: false,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.users.editUserPage.changePasswordTitle",
    defaultMessage: "Change password"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.users.editUserPage.changePasswordDescription",
    defaultMessage: "The user will not be able to log in using their previous password."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => setAction('changePassword'),
    size: "s",
    "data-test-subj": "editUserChangePasswordButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.users.editUserPage.changePasswordButton",
    defaultMessage: "Change password"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), user.enabled === false ? /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    hasShadow: false,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.users.editUserPage.enableUserTitle",
    defaultMessage: "Activate user"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.users.editUserPage.enableUserDescription",
    defaultMessage: "Allow the user to access Elastic."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => setAction('enableUser'),
    size: "s",
    "data-test-subj": "editUserEnableUserButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.users.editUserPage.enableUserButton",
    defaultMessage: "Activate user"
  }))))) : /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    hasShadow: false,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.users.editUserPage.disableUserTitle",
    defaultMessage: "Deactivate user"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.users.editUserPage.disableUserDescription",
    defaultMessage: "Prevent the user from accessing Elastic."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => setAction('disableUser'),
    size: "s",
    "data-test-subj": "editUserDisableUserButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.users.editUserPage.disableUserButton",
    defaultMessage: "Deactivate user"
  }))))), !isReservedUser && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    hasShadow: false,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.users.editUserPage.deleteUserTitle",
    defaultMessage: "Delete user"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.users.editUserPage.deleteUserDescription",
    defaultMessage: "Permanently delete the user and remove access to Elastic."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => setAction('deleteUser'),
    size: "s",
    color: "danger",
    "data-test-subj": "editUserDeleteUserButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.users.editUserPage.deleteUserButton",
    defaultMessage: "Delete user"
  }))))))));
};
exports.EditUserPage = EditUserPage;