"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoleComboBox = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _model = require("../../../common/model");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RoleComboBox = props => {
  var _groupedOptions$custo, _groupedOptions$user, _groupedOptions$admin, _groupedOptions$syste, _groupedOptions$depre;
  const onRolesChange = selectedItems => {
    props.onChange(selectedItems.map(item => item.label));
  };
  const roleNameToOption = roleName => {
    var _ref, _ref2, _ref3, _ref4, _roleDefinition$metad;
    const roleDefinition = props.availableRoles.find(role => role.name === roleName);
    const isReserved = (_ref = roleDefinition && (0, _model.isRoleReserved)(roleDefinition)) !== null && _ref !== void 0 ? _ref : false;
    const isDeprecated = (_ref2 = roleDefinition && (0, _model.isRoleDeprecated)(roleDefinition)) !== null && _ref2 !== void 0 ? _ref2 : false;
    const isSystem = (_ref3 = roleDefinition && (0, _model.isRoleSystem)(roleDefinition)) !== null && _ref3 !== void 0 ? _ref3 : false;
    const isAdmin = (_ref4 = roleDefinition && (0, _model.isRoleAdmin)(roleDefinition)) !== null && _ref4 !== void 0 ? _ref4 : false;
    return {
      color: isDeprecated ? 'warning' : isReserved ? 'primary' : undefined,
      'data-test-subj': `roleOption-${roleName}`,
      label: roleName,
      value: {
        isReserved,
        isDeprecated,
        isSystem,
        isAdmin,
        deprecatedReason: roleDefinition === null || roleDefinition === void 0 ? void 0 : (_roleDefinition$metad = roleDefinition.metadata) === null || _roleDefinition$metad === void 0 ? void 0 : _roleDefinition$metad._deprecated_reason,
        description: roleDefinition === null || roleDefinition === void 0 ? void 0 : roleDefinition.description
      }
    };
  };
  const options = props.availableRoles.map(role => roleNameToOption(role.name));
  const selectedOptions = props.selectedRoleNames.map(roleNameToOption);
  const groupedOptions = options.reduce((acc, option) => {
    var _option$value, _option$value2, _option$value3, _option$value4;
    const type = (_option$value = option.value) !== null && _option$value !== void 0 && _option$value.isDeprecated ? 'deprecated' : (_option$value2 = option.value) !== null && _option$value2 !== void 0 && _option$value2.isSystem ? 'system' : (_option$value3 = option.value) !== null && _option$value3 !== void 0 && _option$value3.isAdmin ? 'admin' : (_option$value4 = option.value) !== null && _option$value4 !== void 0 && _option$value4.isReserved ? 'user' : 'custom';
    if (!acc[type]) {
      acc[type] = [];
    }
    acc[type].push(option);
    return acc;
  }, {});
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "rolesDropdown",
    id: props.id,
    placeholder: props.placeholder || _i18n.i18n.translate('xpack.security.management.users.roleComboBox.placeholder', {
      defaultMessage: 'Select roles'
    }),
    onChange: onRolesChange,
    isLoading: props.isLoading,
    isDisabled: props.isDisabled,
    options: [{
      label: _i18n.i18n.translate('xpack.security.management.users.roleComboBox.customRoles', {
        defaultMessage: 'Custom roles'
      }),
      options: (_groupedOptions$custo = groupedOptions.custom) !== null && _groupedOptions$custo !== void 0 ? _groupedOptions$custo : []
    }, {
      label: _i18n.i18n.translate('xpack.security.management.users.roleComboBox.userRoles', {
        defaultMessage: 'User roles'
      }),
      options: (_groupedOptions$user = groupedOptions.user) !== null && _groupedOptions$user !== void 0 ? _groupedOptions$user : []
    }, {
      label: _i18n.i18n.translate('xpack.security.management.users.roleComboBox.AdminRoles', {
        defaultMessage: 'Admin roles'
      }),
      options: (_groupedOptions$admin = groupedOptions.admin) !== null && _groupedOptions$admin !== void 0 ? _groupedOptions$admin : []
    }, {
      label: _i18n.i18n.translate('xpack.security.management.users.roleComboBox.systemRoles', {
        defaultMessage: 'System roles'
      }),
      options: (_groupedOptions$syste = groupedOptions.system) !== null && _groupedOptions$syste !== void 0 ? _groupedOptions$syste : []
    }, {
      label: _i18n.i18n.translate('xpack.security.management.users.roleComboBox.deprecatedRoles', {
        defaultMessage: 'Deprecated roles'
      }),
      options: (_groupedOptions$depre = groupedOptions.deprecated) !== null && _groupedOptions$depre !== void 0 ? _groupedOptions$depre : []
    }],
    selectedOptions: selectedOptions,
    renderOption: renderOption
  });
};
exports.RoleComboBox = RoleComboBox;
function renderOption(option) {
  var _option$value5, _option$value6, _option$value7, _option$value8;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, (_option$value5 = option.value) !== null && _option$value5 !== void 0 && _option$value5.description ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "left",
    content: (_option$value6 = option.value) === null || _option$value6 === void 0 ? void 0 : _option$value6.description
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, option.label)) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, option.label)), (_option$value7 = option.value) !== null && _option$value7 !== void 0 && _option$value7.isDeprecated ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: option.color
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.users.roleComboBox.deprecatedBadge",
    defaultMessage: "deprecated"
  }))) : (_option$value8 = option.value) !== null && _option$value8 !== void 0 && _option$value8.isReserved ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: option.color
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.users.roleComboBox.reservedBadge",
    defaultMessage: "built in"
  }))) : undefined);
}