"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoggedOutPage = LoggedOutPage;
exports.renderLoggedOutPage = renderLoggedOutPage;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _i18nReact = require("@kbn/i18n-react");
var _std = require("@kbn/std");
var _components = require("../components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function LoggedOutPage({
  basePath,
  customBranding
}) {
  const customBrandingValue = (0, _useObservable.default)(customBranding.customBranding$);
  return /*#__PURE__*/_react.default.createElement(_components.AuthenticationStatePage, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.loggedOut.title",
      defaultMessage: "Successfully logged out"
    }),
    logo: customBrandingValue === null || customBrandingValue === void 0 ? void 0 : customBrandingValue.logo
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    href: (0, _std.parseNextURL)(window.location.href, basePath.serverBasePath)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.loggedOut.login",
    defaultMessage: "Log in"
  })));
}
function renderLoggedOutPage(services, {
  element
}, props) {
  _reactDom.default.render(services.rendering.addContext(/*#__PURE__*/_react.default.createElement(LoggedOutPage, props)), element);
  return () => _reactDom.default.unmountComponentAtNode(element);
}