"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useProfilerReadContext = exports.useProfilerActionContext = exports.ProfileContextProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _store = require("../store");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProfilerReadContext = /*#__PURE__*/(0, _react.createContext)(null);
const ProfilerActionContext = /*#__PURE__*/(0, _react.createContext)(null);
const ProfileContextProvider = ({
  children
}) => {
  const {
    dispatch,
    state
  } = (0, _store.useStore)();
  return /*#__PURE__*/_react.default.createElement(ProfilerReadContext.Provider, {
    value: state
  }, /*#__PURE__*/_react.default.createElement(ProfilerActionContext.Provider, {
    value: dispatch
  }, children));
};
exports.ProfileContextProvider = ProfileContextProvider;
const useProfilerReadContext = () => {
  const ctx = (0, _react.useContext)(ProfilerReadContext);
  if (ctx == null) {
    throw new Error(`useProfilerReadContext must be called inside ProfilerReadContext`);
  }
  return ctx;
};
exports.useProfilerReadContext = useProfilerReadContext;
const useProfilerActionContext = () => {
  const ctx = (0, _react.useContext)(ProfilerActionContext);
  if (ctx == null) {
    throw new Error(`useProfilerActionContext must be called inside ProfilerActionContext`);
  }
  return ctx;
};
exports.useProfilerActionContext = useProfilerActionContext;