"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProfileTree = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _index_details = require("./index_details");
var _shard_details = require("./shard_details");
var _init_data = require("./init_data");
var _highlight_context = require("./highlight_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProfileTree = exports.ProfileTree = /*#__PURE__*/(0, _react.memo)(({
  data,
  target,
  onHighlight,
  onDataInitError
}) => {
  let content = null;
  if (data && data.length) {
    try {
      const sortedIndices = (0, _init_data.initDataFor)(target)(data);
      content = /*#__PURE__*/_react.default.createElement(_highlight_context.HighlightContextProvider, {
        onHighlight: onHighlight
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        className: "prfDevTool__profileTree__container",
        gutterSize: "none",
        direction: "column"
      }, sortedIndices.map(index => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: index.name,
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        className: "prfDevTool__profileTree__panel prfDevTool__profileTree__index",
        gutterSize: "none",
        key: index.name,
        direction: "column"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_index_details.IndexDetails, {
        index: index
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, index.shards.map((shard, idx) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        key: shard.id[1] + `_${idx}`
      }, /*#__PURE__*/_react.default.createElement(_shard_details.ShardDetails, {
        index: index,
        shard: shard,
        operations: shard[target]
      }), idx < index.shards.length - 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }) : undefined))))))));
    } catch (e) {
      onDataInitError(e);
    }
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "prfDevTool__main__profiletree"
  }, content);
});