"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SynonymSets = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_kibana = require("../../hooks/use_kibana");
var _api_routes = require("../../../common/api_routes");
var _pagination = require("../../../common/pagination");
var _use_fetch_synonyms_sets = require("../../hooks/use_fetch_synonyms_sets");
var _delete_synonyms_set_modal = require("./delete_synonyms_set_modal");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SynonymSets = () => {
  const {
    services: {
      application,
      http
    }
  } = (0, _use_kibana.useKibana)();
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(_pagination.DEFAULT_PAGE_VALUE.size);
  const {
    from
  } = (0, _pagination.paginationToPage)({
    pageIndex,
    pageSize,
    totalItemCount: 0
  });
  const {
    data: synonyms
  } = (0, _use_fetch_synonyms_sets.useFetchSynonymsSets)({
    from,
    size: pageSize
  });
  const [synonymsSetToDelete, setSynonymsSetToDelete] = (0, _react.useState)(null);
  if (!synonyms) {
    return null;
  }
  const pagination = {
    initialPageSize: 25,
    pageSizeOptions: [10, 25, 50],
    ...synonyms._meta,
    pageSize,
    pageIndex
  };
  const columns = [{
    field: 'synonyms_set',
    name: _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetTable.nameColumn', {
      defaultMessage: 'Synonyms Set'
    }),
    render: name => /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "synonyms-set-item-name"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "searchSynonymsColumnsLink",
      onClick: () => application.navigateToUrl(http.basePath.prepend(`${_api_routes.PLUGIN_ROUTE_ROOT}/sets/${name}`))
    }, name))
  }, {
    field: 'count',
    name: _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetTable.ruleCount', {
      defaultMessage: 'Rule Count'
    }),
    render: ruleCount => /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "synonyms-set-item-rule-count"
    }, ruleCount)
  }, {
    actions: [{
      name: _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetTable.actions.delete', {
        defaultMessage: 'Delete'
      }),
      description: synonymsSet => _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetTable.actions.deleteDescription', {
        defaultMessage: 'Delete synonyms set with {name}',
        values: {
          name: synonymsSet.synonyms_set
        }
      }),
      icon: 'trash',
      color: 'danger',
      type: 'icon',
      onClick: synonymsSet => {
        setSynonymsSetToDelete(synonymsSet.synonyms_set);
      }
    }, {
      name: _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetTable.actions.edit', {
        defaultMessage: 'Edit'
      }),
      description: synonymsSet => _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetTable.actions.editDescription', {
        defaultMessage: 'Edit synonyms set {name}',
        values: {
          name: synonymsSet.synonyms_set
        }
      }),
      icon: 'pencil',
      color: 'text',
      type: 'icon',
      onClick: synonymsSet => application.navigateToUrl(http.basePath.prepend(`${_api_routes.PLUGIN_ROUTE_ROOT}/sets/${synonymsSet.synonyms_set}`))
    }]
  }];
  return /*#__PURE__*/_react.default.createElement("div", null, synonymsSetToDelete && /*#__PURE__*/_react.default.createElement(_delete_synonyms_set_modal.DeleteSynonymsSetModal, {
    synonymsSetId: synonymsSetToDelete,
    closeDeleteModal: () => setSynonymsSetToDelete(null)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "synonyms-set-table",
    items: synonyms.data,
    columns: columns,
    pagination: pagination,
    onChange: ({
      page: changedPage
    }) => {
      setPageIndex(changedPage.index);
      setPageSize(changedPage.size);
    }
  }));
};
exports.SynonymSets = SynonymSets;