"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorPrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ERROR_MESSAGES = {
  generic: {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.search.synonyms.errorTitle",
      defaultMessage: "An error occurred"
    }),
    body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.search.synonyms.errorDescription",
      defaultMessage: "An error occured while fetching synonyms. Check Kibana logs for more information."
    })
  },
  missingPermissions: {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.search.synonyms.missingPermissionsTitle",
      defaultMessage: "Missing permissions"
    }),
    body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.search.synonyms.missingPermissionsDescription",
      defaultMessage: "You do not have the necessary permissions to manage synonyms. Contact your system administrator."
    })
  }
};
const ErrorPrompt = ({
  errorType
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "logoEnterpriseSearch",
    title: /*#__PURE__*/_react.default.createElement("h2", null, ERROR_MESSAGES[errorType].title),
    body: /*#__PURE__*/_react.default.createElement("p", null, ERROR_MESSAGES[errorType].body)
  });
};
exports.ErrorPrompt = ErrorPrompt;