"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchQueryRulesPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _server = require("@kbn/core/server");
var _common = require("@kbn/features-plugin/common");
var _routes = require("./routes");
var _common2 = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SearchQueryRulesPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.logger = initializerContext.logger.get();
  }
  setup(core, plugins) {
    const router = core.http.createRouter();
    (0, _routes.defineRoutes)({
      router,
      logger: this.logger
    });
    plugins.features.registerKibanaFeature({
      id: _common2.PLUGIN_ID,
      name: _common2.PLUGIN_TITLE,
      order: 0,
      category: _server.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      app: ['kibana', _common2.PLUGIN_ID],
      scope: [_common.KibanaFeatureScope.Spaces, _common.KibanaFeatureScope.Security],
      catalogue: [_common2.PLUGIN_ID],
      privileges: {
        all: {
          app: ['kibana', _common2.PLUGIN_ID],
          api: ['manage_search_query_rules'],
          catalogue: [_common2.PLUGIN_ID],
          savedObject: {
            all: [],
            read: []
          },
          ui: ['manage']
        },
        read: {
          disabled: true,
          savedObject: {
            all: [],
            read: []
          },
          ui: []
        }
      }
    });
    return {};
  }
  start(_) {
    return {};
  }
  stop() {}
}
exports.SearchQueryRulesPlugin = SearchQueryRulesPlugin;