"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchQueryRulesRuleset = void 0;
var _is_query_ruleset_exist = require("./is_query_ruleset_exist");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchQueryRulesRuleset = async (client, rulesetId) => {
  if (await (0, _is_query_ruleset_exist.isQueryRulesetExist)(client, rulesetId)) {
    const ruleset = await client.queryRules.getRuleset({
      ruleset_id: rulesetId
    });
    return ruleset;
  }
  return null;
};
exports.fetchQueryRulesRuleset = fetchQueryRulesRuleset;