"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useQueryRulesBreadcrumbs = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QUERY_RULES_BREADCRUMB_TEXT = _i18n.i18n.translate('xpack.searchQueryRules.breadcrumbs.queryRules', {
  defaultMessage: 'Query Rules'
});
const useQueryRulesBreadcrumbs = rulesetId => {
  var _cloud$isServerlessEn;
  const {
    searchNavigation,
    history,
    cloud
  } = (0, _use_kibana.useKibana)().services;
  const isServerless = (_cloud$isServerlessEn = cloud === null || cloud === void 0 ? void 0 : cloud.isServerlessEnabled) !== null && _cloud$isServerlessEn !== void 0 ? _cloud$isServerlessEn : false;
  (0, _react.useEffect)(() => {
    if (!isServerless) {
      searchNavigation === null || searchNavigation === void 0 ? void 0 : searchNavigation.breadcrumbs.setSearchBreadCrumbs([{
        text: _i18n.i18n.translate('xpack.searchQueryRules.breadcrumbs.relevance', {
          defaultMessage: 'Relevance'
        })
      }, ...(rulesetId && rulesetId.trim().length > 0 ? [{
        text: QUERY_RULES_BREADCRUMB_TEXT,
        ...(0, _public.reactRouterNavigate)(history, '/')
      }, {
        text: rulesetId
      }] : [{
        text: QUERY_RULES_BREADCRUMB_TEXT
      }])]);
    } else {
      if (rulesetId && rulesetId.trim().length > 0) {
        searchNavigation === null || searchNavigation === void 0 ? void 0 : searchNavigation.breadcrumbs.setSearchBreadCrumbs([{
          text: rulesetId
        }]);
      }
    }
    return () => {
      // Clear breadcrumbs on unmount;
      searchNavigation === null || searchNavigation === void 0 ? void 0 : searchNavigation.breadcrumbs.clearBreadcrumbs();
    };
  }, [searchNavigation, history, rulesetId, isServerless]);
};
exports.useQueryRulesBreadcrumbs = useQueryRulesBreadcrumbs;