"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useQueryRulesetDetailState = void 0;
var _react = require("react");
var _use_fetch_query_ruleset = require("../../hooks/use_fetch_query_ruleset");
var _query_rules_utils = require("../../utils/query_rules_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createEmptyRuleset = rulesetId => ({
  ruleset_id: rulesetId,
  rules: []
});
const useQueryRulesetDetailState = ({
  rulesetId,
  createMode
}) => {
  const {
    data,
    isInitialLoading,
    isError,
    error
  } = (0, _use_fetch_query_ruleset.useFetchQueryRuleset)(rulesetId, !createMode);
  const [queryRuleset, setQueryRuleset] = (0, _react.useState)(createMode ? createEmptyRuleset(rulesetId) : null);
  const [rules, setRules] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    if (!createMode && !isError && data) {
      const normalizedRuleset = (0, _query_rules_utils.normalizeQueryRuleset)(data);
      setQueryRuleset(normalizedRuleset);
      setRules(normalizedRuleset.rules);
    }
  }, [data, setRules, setQueryRuleset, createMode, isError]);
  const updateRule = updatedRule => {
    const newRules = rules.map(rule => rule.rule_id === updatedRule.rule_id ? updatedRule : rule);
    setRules([...newRules]);
  };
  const addNewRule = newRule => {
    setRules(prevRules => [...prevRules, {
      ...newRule
    }]);
  };
  const deleteRule = ruleId => {
    const newRules = rules.filter(rule => rule.rule_id !== ruleId);
    setRules(newRules);
  };
  return {
    queryRuleset,
    rules,
    setNewRules: setRules,
    updateRule,
    addNewRule,
    deleteRule,
    isInitialLoading,
    isError,
    error
  };
};
exports.useQueryRulesetDetailState = useQueryRulesetDetailState;