"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryRuleDraggableListItem = exports.QueryRuleDraggableList = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _use_usage_tracker = require("../../../hooks/use_usage_tracker");
var _styles = require("../styles");
var _query_rule_draggable_list_header = require("./query_rule_draggable_list_header");
var _query_rule_draggable_item_action_type_badge = require("./query_rule_draggable_item_action_type_badge");
var _query_rule_draggable_item_criteria_display = require("./query_rule_draggable_item_criteria_display");
var _delete_ruleset_rule_modal = require("./delete_ruleset_rule_modal");
var _constants = require("../../../analytics/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QueryRuleDraggableListItem = ({
  index,
  rulesetId,
  rules,
  onEditRuleFlyoutOpen,
  deleteRule,
  queryRule,
  tourInfo,
  isLastItem = false
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const useTracker = (0, _use_usage_tracker.useUsageTracker)();
  const [isPopoverOpen, setIsPopoverOpen] = _react.default.useState(false);
  const localTourTargetRef = (0, _react.useRef)(null);
  const effectiveRef = (tourInfo === null || tourInfo === void 0 ? void 0 : tourInfo.tourTargetRef) || localTourTargetRef;
  const closePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, []);
  const openPopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(true);
  }, []);
  const [ruleToDelete, setRuleToDelete] = (0, _react.useState)(null);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ruleToDelete && /*#__PURE__*/_react.default.createElement(_delete_ruleset_rule_modal.DeleteRulesetRuleModal, {
    closeDeleteModal: () => setRuleToDelete(null),
    onConfirm: () => {
      if (deleteRule) {
        deleteRule(ruleToDelete);
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDraggable, {
    spacing: "m",
    key: queryRule.rule_id,
    index: index,
    draggableId: queryRule.rule_id,
    customDragHandle: true,
    hasInteractiveChildren: true,
    "data-test-subj": "searchQueryRulesDraggableItem"
  }, provided => /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    ref: isLastItem ? effectiveRef : undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, (0, _extends2.default)({
    color: "transparent",
    paddingSize: "s"
  }, provided.dragHandleProps, {
    "aria-label": "Drag Handle"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "grab"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
    color: "subdued"
  }, index + 1)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    responsive: false
  }, Array.isArray(queryRule.criteria) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, queryRule.criteria.slice(0, 3).map((criteria, criteriaIndex) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: criteria.type + criteriaIndex,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_query_rule_draggable_item_criteria_display.QueryRuleDraggableItemCriteriaDisplay, {
    criteria: criteria
  }))), queryRule.criteria.length > 3 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRulesetDetail.draggableList.queryRulesCriteriaMoreLabel",
    defaultMessage: "+{count} more",
    values: {
      count: queryRule.criteria.length - 3
    }
  })))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_query_rule_draggable_item_criteria_display.QueryRuleDraggableItemCriteriaDisplay, {
    criteria: queryRule.criteria
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_query_rule_draggable_item_action_type_badge.QueryRuleDraggableListItemActionTypeBadge, {
    queryRule: queryRule
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "queryRuleActionsPopover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": _i18n.i18n.translate('xpack.search.queryRulesetDetail.draggableList.actionsButton.aria.label', {
        defaultMessage: 'Click to reach actions menu for rule {ruleId}',
        values: {
          ruleId: queryRule.rule_id
        }
      }),
      "data-test-subj": "searchQueryRulesQueryRulesetDetailButton",
      iconType: "boxesHorizontal",
      color: "text",
      onClick: () => {
        openPopover();
      }
    }),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "edit",
      icon: "pencil",
      "data-test-subj": "searchQueryRulesQueryRulesetDetailEditButton",
      onClick: () => {
        useTracker === null || useTracker === void 0 ? void 0 : useTracker.click(_constants.AnalyticsEvents.editRuleClicked);
        onEditRuleFlyoutOpen(queryRule.rule_id);
        closePopover();
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.search.queryRulesetDetail.draggableList.actions.edit",
      defaultMessage: "Edit rule"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      toolTipContent: rules.length === 1 ? _i18n.i18n.translate('xpack.search.queryRulesetDetail.draggableList.actions.deleteTooltip', {
        defaultMessage: 'The ruleset must contains at least 1 rule.'
      }) : undefined,
      disabled: rules.length === 1,
      key: "delete",
      icon: "trash",
      css: (0, _react2.css)`
                              color: ${rules.length === 1 ? euiTheme.colors.textDisabled : euiTheme.colors.danger};
                            `,
      "data-test-subj": "searchQueryRulesQueryRulesetDetailDeleteButton",
      onClick: () => {
        useTracker === null || useTracker === void 0 ? void 0 : useTracker.click(_constants.AnalyticsEvents.deleteRuleClicked);
        setRuleToDelete(queryRule.rule_id);
        closePopover();
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.search.queryRulesetDetail.draggableList.actions.delete",
      defaultMessage: "Delete rule"
    }))],
    className: "euiContextMenuPanel--inPopover",
    "data-test-subj": "searchQueryRulesQueryRulesetDetailContextMenu"
  })))))))));
};
exports.QueryRuleDraggableListItem = QueryRuleDraggableListItem;
const QueryRuleDraggableList = ({
  rules,
  rulesetId,
  onEditRuleFlyoutOpen,
  deleteRule,
  onReorder,
  tourInfo
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const useTracker = (0, _use_usage_tracker.useUsageTracker)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDragDropContext, {
    onDragEnd: ({
      source,
      destination
    }) => {
      if (source && destination) {
        useTracker === null || useTracker === void 0 ? void 0 : useTracker.click(_constants.AnalyticsEvents.rulesReordered);
        const items = (0, _eui.euiDragDropReorder)(rules, source.index, destination.index);
        onReorder(items);
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_query_rule_draggable_list_header.QueryRuleDraggableListHeader, {
    tourInfo: tourInfo
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDroppable, {
    droppableId: "queryRuleListDropabble",
    spacing: "m",
    css: (0, _styles.DroppableContainer)(euiTheme),
    "data-test-subj": "searchQueryRulesDroppable"
  }, rules.map((queryRule, index) => /*#__PURE__*/_react.default.createElement(QueryRuleDraggableListItem, {
    key: queryRule.rule_id,
    queryRule: queryRule,
    deleteRule: deleteRule,
    rulesetId: rulesetId,
    tourInfo: tourInfo,
    index: index,
    rules: rules,
    "data-test-subj": `searchQueryRulesDraggableItem-${queryRule.rule_id}`,
    onEditRuleFlyoutOpen: onEditRuleFlyoutOpen,
    isLastItem: index === rules.length - 1
  })))));
};
exports.QueryRuleDraggableList = QueryRuleDraggableList;