"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryRuleDetailPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _query_rule_draggable_list = require("./query_rule_draggable_list/query_rule_draggable_list");
var _query_rule_flyout = require("./query_rule_flyout/query_rule_flyout");
var _use_generate_rule_id = require("../../hooks/use_generate_rule_id");
var _ruleset_detail_empty_prompt = require("../empty_prompt/ruleset_detail_empty_prompt");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _constants = require("../../analytics/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QueryRuleDetailPanel = ({
  rulesetId,
  tourInfo,
  rules,
  setIsFormDirty,
  setNewRules,
  updateRule,
  addNewRule,
  deleteRule,
  createMode = false
}) => {
  const [ruleIdToEdit, setRuleIdToEdit] = _react.default.useState(null);
  const [flyoutMode, setFlyoutMode] = _react.default.useState('edit');
  const useTracker = (0, _use_usage_tracker.useUsageTracker)();
  const {
    mutate: generateRuleId
  } = (0, _use_generate_rule_id.useGenerateRuleId)(rulesetId);
  (0, _react.useEffect)(() => {
    if (createMode && rules.length === 0) {
      generateRuleId(undefined, {
        onSuccess: newRuleId => {
          setFlyoutMode('create');
          setRuleIdToEdit(newRuleId);
        }
      });
    }
  }, [createMode, rules.length, addNewRule, generateRuleId, rulesetId]);
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    restrictWidth: true
  }, ruleIdToEdit !== null && /*#__PURE__*/_react.default.createElement(_query_rule_flyout.QueryRuleFlyout, {
    rules: rules,
    rulesetId: rulesetId,
    ruleId: ruleIdToEdit,
    onSave: rule => {
      if (flyoutMode === 'create') {
        addNewRule(rule);
      } else {
        updateRule(rule);
      }
      setRuleIdToEdit(null);
      setFlyoutMode('edit');
    },
    onClose: () => {
      setRuleIdToEdit(null);
      setFlyoutMode('edit');
    },
    setIsFormDirty: setIsFormDirty,
    createMode: flyoutMode === 'create'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "plusInCircle",
    color: "primary",
    "data-test-subj": "queryRulesetDetailAddRuleButton",
    onClick: () => {
      useTracker === null || useTracker === void 0 ? void 0 : useTracker.click(_constants.AnalyticsEvents.addRuleClicked);
      generateRuleId(undefined, {
        onSuccess: newRuleId => {
          setFlyoutMode('create');
          setRuleIdToEdit(newRuleId);
        }
      });
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.queryRules.queryRulesetDetail.addRuleButton",
    defaultMessage: "Add rule"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.queryRules.queryRulesetDetail.ruleCount",
    defaultMessage: "{ruleCount, plural, one {# rule} other {# rules}}",
    values: {
      ruleCount: rules.length
    },
    "data-test-subj": "queryRulesetDetailRuleCount"
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, rules.length === 0 && /*#__PURE__*/_react.default.createElement(_ruleset_detail_empty_prompt.RulesetDetailEmptyPrompt, null), rules.length > 0 && /*#__PURE__*/_react.default.createElement(_query_rule_draggable_list.QueryRuleDraggableList, {
    rules: rules,
    rulesetId: rulesetId,
    onReorder: newRules => {
      setNewRules(newRules);
      if (setIsFormDirty) {
        setIsFormDirty(true);
      }
    },
    onEditRuleFlyoutOpen: ruleId => {
      setFlyoutMode('edit');
      setRuleIdToEdit(ruleId);
    },
    tourInfo: tourInfo,
    deleteRule: ruleId => {
      if (setIsFormDirty) {
        setIsFormDirty(true);
      }
      deleteRule === null || deleteRule === void 0 ? void 0 : deleteRule(ruleId);
    }
  }))));
};
exports.QueryRuleDetailPanel = QueryRuleDetailPanel;