"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchPlaygroundPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _server = require("@kbn/core/server");
var _common = require("@kbn/features-plugin/common");
var _events = require("./analytics/events");
var _routes = require("./routes");
var _common2 = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SearchPlaygroundPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.logger = initializerContext.logger.get();
  }
  setup(core, {
    features
  }) {
    this.logger.debug('searchPlayground: Setup');
    const router = core.http.createRouter();
    (0, _routes.defineRoutes)({
      router,
      logger: this.logger,
      getStartServices: core.getStartServices
    });
    this.registerAnalyticsEvents(core);
    features.registerKibanaFeature({
      id: _common2.PLUGIN_ID,
      minimumLicense: 'enterprise',
      name: _common2.PLUGIN_NAME,
      order: 1,
      category: _server.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      scope: [_common.KibanaFeatureScope.Spaces, _common.KibanaFeatureScope.Security],
      app: ['kibana', _common2.PLUGIN_ID],
      catalogue: [_common2.PLUGIN_ID],
      privileges: {
        all: {
          app: ['kibana', _common2.PLUGIN_ID],
          api: [_common2.PLUGIN_ID],
          catalogue: [_common2.PLUGIN_ID],
          savedObject: {
            all: [],
            read: []
          },
          ui: []
        },
        read: {
          disabled: true,
          savedObject: {
            all: [],
            read: []
          },
          ui: []
        }
      }
    });
    return {};
  }
  start(core) {
    return {};
  }
  registerAnalyticsEvents(core) {
    core.analytics.registerEventType(_events.sendMessageEvent);
  }
  stop() {}
}
exports.SearchPlaygroundPlugin = SearchPlaygroundPlugin;