"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIndicesFields = void 0;
var _reactQuery = require("@tanstack/react-query");
var _use_kibana = require("./use_kibana");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialData = {};
const useIndicesFields = (indices = []) => {
  const {
    services
  } = (0, _use_kibana.useKibana)();
  const {
    data,
    isLoading,
    isFetching
  } = (0, _reactQuery.useQuery)({
    enabled: indices.length > 0,
    queryKey: ['fields', indices.toString()],
    initialData,
    queryFn: async () => {
      const response = await services.http.post(_types.APIRoutes.POST_QUERY_SOURCE_FIELDS, {
        body: JSON.stringify({
          indices
        })
      });
      return response;
    }
  });
  return {
    fields: data,
    isLoading: isLoading || isFetching
  };
};
exports.useIndicesFields = useIndicesFields;