"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.classicNavigationFactory = void 0;
var _i18n = require("@kbn/i18n");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const classicNavigationFactory = (classicItems, core, history) => {
  const navLinks = core.chrome.navLinks.getAll();
  const deepLinks = navLinks.reduce((links, link) => {
    links[link.id] = link;
    return links;
  }, {});
  const currentPath = (0, _utils.stripTrailingSlash)(history.location.pathname);
  const currentLocation = history.createHref({
    pathname: currentPath
  });
  const items = generateSideNavItems(classicItems, core, deepLinks, currentLocation);
  return {
    items,
    icon: 'logoEnterpriseSearch',
    name: _i18n.i18n.translate('xpack.searchNavigation.classicNav.name', {
      defaultMessage: 'Elasticsearch'
    })
  };
};
exports.classicNavigationFactory = classicNavigationFactory;
function generateSideNavItems(classicItems, core, deepLinks, currentLocation) {
  const result = [];
  for (const navItem of classicItems) {
    let children;
    const {
      deepLink,
      items,
      ...rest
    } = navItem;
    if (items) {
      children = generateSideNavItems(items, core, deepLinks, currentLocation);
    }
    let item;
    if (deepLink) {
      const sideNavProps = getSideNavItemLinkProps(deepLink, deepLinks, core, currentLocation);
      if (sideNavProps) {
        var _navItem$name;
        const {
          name,
          ...linkProps
        } = sideNavProps;
        item = {
          ...rest,
          ...linkProps,
          name: (_navItem$name = navItem === null || navItem === void 0 ? void 0 : navItem.name) !== null && _navItem$name !== void 0 ? _navItem$name : name
        };
      }
    } else {
      item = {
        ...rest,
        items: children,
        name: navItem.name
      };
    }
    if (isValidSideNavItem(item)) {
      result.push(item);
    }
  }
  return result;
}
function isValidSideNavItem(item) {
  var _item$items$length, _item$items;
  if (item === undefined) return false;
  if (item.href || item.onClick) return true;
  if ((_item$items$length = item === null || item === void 0 ? void 0 : (_item$items = item.items) === null || _item$items === void 0 ? void 0 : _item$items.length) !== null && _item$items$length !== void 0 ? _item$items$length : 0 > 0) return true;
  return false;
}
function getSideNavItemLinkProps({
  link,
  shouldShowActiveForSubroutes
}, deepLinks, core, currentLocation) {
  const deepLink = deepLinks[link];
  if (!deepLink || !deepLink.url) return undefined;
  const isSelected = Boolean(deepLink.url === currentLocation || shouldShowActiveForSubroutes && currentLocation.startsWith(deepLink.url));
  return {
    onClick: e => {
      e.preventDefault();
      core.application.navigateToUrl(deepLink.url);
    },
    href: deepLink.url,
    name: deepLink.title,
    isSelected
  };
}