"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchInferenceEndpointsPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _server = require("@kbn/core/server");
var _common = require("@kbn/features-plugin/common");
var _routes = require("./routes");
var _constants = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SearchInferenceEndpointsPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.logger = initializerContext.logger.get();
  }
  setup(core, plugins) {
    this.logger.debug('searchInferenceEndpoints: Setup');
    const router = core.http.createRouter();
    (0, _routes.defineRoutes)({
      logger: this.logger,
      router
    });
    plugins.features.registerKibanaFeature({
      id: _constants.PLUGIN_ID,
      minimumLicense: 'enterprise',
      name: _constants.PLUGIN_NAME,
      order: 2,
      category: _server.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      app: ['kibana', _constants.PLUGIN_ID],
      scope: [_common.KibanaFeatureScope.Spaces, _common.KibanaFeatureScope.Security],
      catalogue: [_constants.PLUGIN_ID],
      privileges: {
        all: {
          app: ['kibana', _constants.PLUGIN_ID],
          api: [],
          catalogue: [_constants.PLUGIN_ID],
          savedObject: {
            all: [],
            read: []
          },
          ui: []
        },
        read: {
          disabled: true,
          savedObject: {
            all: [],
            read: []
          },
          ui: []
        }
      }
    });
    return {};
  }
  start(core) {
    return {};
  }
  stop() {}
}
exports.SearchInferenceEndpointsPlugin = SearchInferenceEndpointsPlugin;