"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScanUsageResults = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _uiTheme = require("@kbn/ui-theme");
var _react2 = require("@emotion/react");
var _deeplinksSearch = require("@kbn/deeplinks-search");
var _constants = require("@kbn/deeplinks-search/constants");
var _use_kibana = require("../../../../../../hooks/use_kibana");
var _render_message_with_icon = require("./render_message_with_icon");
var i18n = _interopRequireWildcard(require("../delete/confirm_delete_endpoint/translations"));
var _list_usage_results = require("./list_usage_results");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ScanUsageResults = ({
  list,
  ignoreWarningCheckbox,
  onIgnoreWarningCheckboxChange
}) => {
  const {
    services: {
      application,
      serverless
    }
  } = (0, _use_kibana.useKibana)();
  const handleNavigateToIndexManagement = () => {
    if (serverless) {
      application === null || application === void 0 ? void 0 : application.navigateToApp(_constants.SEARCH_INDICES, {
        openInNewTab: true
      });
    } else {
      application === null || application === void 0 ? void 0 : application.navigateToApp(_deeplinksSearch.ENTERPRISE_SEARCH_CONTENT_APP_ID, {
        path: `search_indices`,
        openInNewTab: true
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_render_message_with_icon.RenderMessageWithIcon, {
    icon: "warning",
    color: "danger",
    label: i18n.POTENTIAL_FAILURE_LABEL,
    labelColor: "danger"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    css: (0, _react2.css)`
                      font-weight: ${_uiTheme.euiThemeVars.euiCodeFontWeightBold};
                    `
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.COUNT_USAGE_LABEL(list.length)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: handleNavigateToIndexManagement,
    iconType: "popout",
    iconSide: "right",
    iconSize: "s",
    flush: "both",
    color: "text",
    "aria-label": i18n.OPEN_INDEX_MANAGEMENT,
    "data-test-subj": "inferenceManagementOpenIndexManagement"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, i18n.OPEN_INDEX_MANAGEMENT))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_list_usage_results.ListUsageResults, {
    list: list
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    "data-test-subj": "warningCheckbox",
    id: 'ignoreWarningCheckbox',
    label: i18n.IGNORE_POTENTIAL_ERRORS_LABEL,
    checked: ignoreWarningCheckbox,
    onChange: e => onIgnoreWarningCheckboxChange(e.target.checked)
  }))));
};
exports.ScanUsageResults = ScanUsageResults;