"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ListUsageResults = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../delete/confirm_delete_endpoint/translations"));
var _index_item = require("./index_item");
var _pipeline_item = require("./pipeline_item");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ListUsageResults = ({
  list
}) => {
  const [term, setTerm] = (0, _react.useState)('');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    placeholder: i18n.SEARCH_LABEL,
    value: term,
    onChange: e => setTerm(e.target.value),
    isClearable: true,
    "aria-label": i18n.SEARCH_ARIA_LABEL,
    fullWidth: true,
    "data-test-subj": "usageFieldSearch"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, list.filter(item => item.id.toLowerCase().includes(term.toLowerCase())).map((item, id) => {
    if (item.type === 'Pipeline') {
      return /*#__PURE__*/_react.default.createElement(_pipeline_item.PipelineItem, {
        usageItem: item,
        key: id
      });
    } else {
      return /*#__PURE__*/_react.default.createElement(_index_item.IndexItem, {
        usageItem: item,
        key: id
      });
    }
  })));
};
exports.ListUsageResults = ListUsageResults;