"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerStatusRoutes = registerStatusRoutes;
var _routes = require("../../common/routes");
var _status = require("../lib/status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerStatusRoutes(router, logger) {
  router.get({
    path: _routes.GET_STATUS_ROUTE,
    validate: {},
    security: {
      authz: {
        enabled: false,
        reason: 'This route delegates authorization to the scoped ES client'
      }
    },
    options: {
      access: 'internal'
    }
  }, async (context, _request, response) => {
    const core = await context.core;
    const client = core.elasticsearch.client.asCurrentUser;
    const body = await (0, _status.fetchIndicesStatus)(client, logger);
    return response.ok({
      body,
      headers: {
        'content-type': 'application/json'
      }
    });
  });
  router.get({
    path: _routes.GET_USER_PRIVILEGES_ROUTE,
    validate: {},
    security: {
      authz: {
        enabled: false,
        reason: 'This route delegates authorization to the scoped ES client'
      }
    },
    options: {
      access: 'internal'
    }
  }, async (context, _request, response) => {
    const core = await context.core;
    const client = core.elasticsearch.client.asCurrentUser;
    const body = await (0, _status.fetchUserStartPrivileges)(client, logger);
    return response.ok({
      body,
      headers: {
        'content-type': 'application/json'
      }
    });
  });
}