"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIndexDocumentSearch = exports.INDEX_SEARCH_POLLING = void 0;
var _searchIndexDocuments = require("@kbn/search-index-documents");
var _reactQuery = require("@tanstack/react-query");
var _use_kibana = require("../use_kibana");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_PAGINATION = {
  from: 0,
  has_more_hits_than_total: false,
  size: _constants.DEFAULT_DOCUMENT_PAGE_SIZE,
  total: 0
};
const INDEX_SEARCH_POLLING = exports.INDEX_SEARCH_POLLING = 5 * 1000;
const useIndexDocumentSearch = indexName => {
  var _response$data$result, _response$data, _response$data$result2, _response$data$result3;
  const {
    services: {
      http
    }
  } = (0, _use_kibana.useKibana)();
  const response = (0, _reactQuery.useQuery)({
    queryKey: [_constants.QueryKeys.SearchDocuments, indexName],
    refetchInterval: INDEX_SEARCH_POLLING,
    refetchIntervalInBackground: true,
    refetchOnWindowFocus: 'always',
    queryFn: async ({
      signal
    }) => http.post(`/internal/serverless_search/indices/${indexName}/search`, {
      body: JSON.stringify({
        searchQuery: '',
        trackTotalHits: true
      }),
      query: {
        page: 0,
        size: _constants.DEFAULT_DOCUMENT_PAGE_SIZE
      },
      signal
    })
  });
  return {
    ...response,
    meta: (0, _searchIndexDocuments.pageToPagination)((_response$data$result = response === null || response === void 0 ? void 0 : (_response$data = response.data) === null || _response$data === void 0 ? void 0 : (_response$data$result2 = _response$data.results) === null || _response$data$result2 === void 0 ? void 0 : (_response$data$result3 = _response$data$result2._meta) === null || _response$data$result3 === void 0 ? void 0 : _response$data$result3.page) !== null && _response$data$result !== void 0 ? _response$data$result : DEFAULT_PAGINATION)
  };
};
exports.useIndexDocumentSearch = useIndexDocumentSearch;