"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchIndexDetailsPageMenuItemPopover = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _use_kibana = require("../../hooks/use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchIndexDetailsPageMenuItemPopover = ({
  showApiReference = false,
  handleDeleteIndexModal
}) => {
  const [showMoreOptions, setShowMoreOptions] = (0, _react.useState)(false);
  const {
    docLinks
  } = (0, _use_kibana.useKibana)().services;
  const contextMenuItems = [showApiReference && /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "apiReference",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "documentation"
    }),
    href: docLinks.links.apiReference,
    size: "s",
    target: "_blank",
    "data-test-subj": "moreOptionsApiReference"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchIndices.moreOptions.apiReferenceLabel",
    defaultMessage: "API Reference"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "deleteIndex",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "danger",
      type: "trash"
    }),
    size: "s",
    onClick: handleDeleteIndexModal,
    "data-test-subj": "moreOptionsDeleteIndex",
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchIndices.moreOptions.deleteIndexLabel",
    defaultMessage: "Delete Index"
  })))].filter(Boolean);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: showMoreOptions,
    closePopover: () => setShowMoreOptions(!showMoreOptions),
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "boxesVertical",
      onClick: () => setShowMoreOptions(!showMoreOptions),
      size: "m",
      "data-test-subj": "moreOptionsActionButton",
      "aria-label": _i18n.i18n.translate('xpack.searchIndices.moreOptions.ariaLabel', {
        defaultMessage: 'More options'
      })
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    "data-test-subj": "moreOptionsContextMenu",
    items: contextMenuItems
  }));
};
exports.SearchIndexDetailsPageMenuItemPopover = SearchIndexDetailsPageMenuItemPopover;