"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.App = void 0;
var _react = _interopRequireDefault(require("react"));
var _usage_tracker_context = require("../contexts/usage_tracker_context");
var _use_kibana = require("../hooks/use_kibana");
var _search_homepage_body = require("./search_homepage_body");
var _search_homepage_header = require("./search_homepage_header");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const App = () => {
  const {
    services: {
      usageCollection
    }
  } = (0, _use_kibana.useKibana)();
  return /*#__PURE__*/_react.default.createElement(_usage_tracker_context.UsageTrackerContextProvider, {
    usageCollection: usageCollection
  }, /*#__PURE__*/_react.default.createElement(_search_homepage_header.SearchHomepageHeader, {
    showEndpointsAPIKeys: false
  }), /*#__PURE__*/_react.default.createElement(_search_homepage_body.SearchHomepageBody, null));
};
exports.App = App;