"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchHomepageHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _endpoints_header_action = require("./endpoints_header_action");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchHomepageHeader = ({
  showEndpointsAPIKeys
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Header, {
  pageTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "data-test-subj": "search-homepage-header-title",
    size: "l"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchHomepage.pageTitle",
    defaultMessage: "Welcome to Search"
  })),
  "data-test-subj": "search-homepage-header",
  rightSideItems: [...(showEndpointsAPIKeys ? [/*#__PURE__*/_react.default.createElement(_endpoints_header_action.EndpointsHeaderAction, null)] : [])]
});
exports.SearchHomepageHeader = SearchHomepageHeader;