"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorConfigurationField = exports.ConfigSensitiveTextArea = exports.ConfigInputTextArea = exports.ConfigInputPassword = exports.ConfigInputField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ = require("../..");
var _connector_configuration = require("./connector_configuration");
var _document_level_security_panel = require("./document_level_security_panel");
var _connector_configuration_utils = require("../../utils/connector_configuration_utils");
var _platinum_license_popover = require("./platinum_license_popover");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ConfigInputField = ({
  configEntry,
  isLoading,
  validateAndSetConfigValue
}) => {
  const {
    isValid,
    required,
    placeholder,
    value,
    label
  } = configEntry;
  const [innerValue, setInnerValue] = (0, _react.useState)(value);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    disabled: isLoading,
    required: required,
    value: (0, _connector_configuration_utils.ensureStringType)(innerValue),
    isInvalid: !isValid,
    onChange: event => {
      setInnerValue(event.target.value);
      validateAndSetConfigValue(event.target.value);
    },
    placeholder: placeholder,
    "aria-label": label
  });
};
exports.ConfigInputField = ConfigInputField;
const ConfigInputTextArea = ({
  isLoading,
  configEntry,
  validateAndSetConfigValue
}) => {
  const {
    isValid,
    required,
    placeholder,
    value,
    label
  } = configEntry;
  const [innerValue, setInnerValue] = (0, _react.useState)(value);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    disabled: isLoading,
    required: required
    // ensures placeholder shows up when value is empty string
    ,
    value: (0, _connector_configuration_utils.ensureStringType)(innerValue) || undefined,
    isInvalid: !isValid,
    onChange: event => {
      setInnerValue(event.target.value);
      validateAndSetConfigValue(event.target.value);
    },
    placeholder: placeholder,
    "aria-label": label
  });
};
exports.ConfigInputTextArea = ConfigInputTextArea;
const ConfigSensitiveTextArea = ({
  isLoading,
  configEntry,
  validateAndSetConfigValue
}) => {
  const {
    key,
    label,
    tooltip
  } = configEntry;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: key + '-accordion',
    buttonContent: tooltip ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("p", null, label)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: tooltip
    }))) : /*#__PURE__*/_react.default.createElement("p", null, label)
  }, /*#__PURE__*/_react.default.createElement(ConfigInputTextArea, {
    isLoading: isLoading,
    configEntry: configEntry,
    validateAndSetConfigValue: validateAndSetConfigValue
  }));
};
exports.ConfigSensitiveTextArea = ConfigSensitiveTextArea;
const ConfigInputPassword = ({
  isLoading,
  configEntry,
  validateAndSetConfigValue
}) => {
  const {
    required,
    value,
    label
  } = configEntry;
  const [innerValue, setInnerValue] = (0, _react.useState)(value);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldPassword, {
    disabled: isLoading,
    required: required,
    type: "dual",
    value: (0, _connector_configuration_utils.ensureStringType)(innerValue),
    onChange: event => {
      setInnerValue(event.target.value);
      validateAndSetConfigValue(event.target.value);
    },
    "aria-label": label
  });
};
exports.ConfigInputPassword = ConfigInputPassword;
const ConnectorConfigurationField = ({
  configEntry,
  isLoading,
  setConfigValue
}) => {
  const {
    hasPlatinumLicense,
    stackManagementLink,
    subscriptionLink
  } = (0, _react.useContext)(_connector_configuration.LicenseContext);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const validateAndSetConfigValue = value => {
    setConfigValue((0, _connector_configuration_utils.ensureCorrectTyping)(configEntry.type, value));
  };
  const {
    key,
    display,
    label,
    options,
    required,
    sensitive,
    tooltip,
    value
  } = configEntry;
  switch (display) {
    case _.DisplayType.DROPDOWN:
      return options.length > 3 ? /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
        disabled: isLoading,
        options: options.map(option => ({
          text: option.label,
          value: option.value
        })),
        required: required,
        value: (0, _connector_configuration_utils.ensureStringType)(value),
        onChange: event => {
          validateAndSetConfigValue(event.target.value);
        },
        "aria-label": label
      }) : /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
        disabled: isLoading,
        idSelected: (0, _connector_configuration_utils.ensureStringType)(value),
        name: key,
        options: options.map(option => ({
          id: option.value,
          label: option.label
        })),
        onChange: id => {
          validateAndSetConfigValue(id);
        },
        "aria-label": label
      });
    case _.DisplayType.NUMERIC:
      return /*#__PURE__*/_react.default.createElement(ConfigInputField, {
        key: key,
        isLoading: isLoading,
        configEntry: configEntry,
        validateAndSetConfigValue: validateAndSetConfigValue
      });
    case _.DisplayType.TEXTAREA:
      const textarea = /*#__PURE__*/_react.default.createElement(ConfigInputTextArea, {
        key: sensitive ? key + '-sensitive-text-area' : key + 'text-area',
        isLoading: isLoading,
        configEntry: configEntry,
        validateAndSetConfigValue: validateAndSetConfigValue
      });
      return sensitive ? /*#__PURE__*/_react.default.createElement(ConfigSensitiveTextArea, {
        isLoading: isLoading,
        configEntry: configEntry,
        validateAndSetConfigValue: validateAndSetConfigValue
      }) : textarea;
    case _.DisplayType.TOGGLE:
      if (key === 'use_document_level_security') {
        return /*#__PURE__*/_react.default.createElement(_document_level_security_panel.DocumentLevelSecurityPanel, {
          toggleSwitch: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            responsive: false,
            gutterSize: "s"
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
            checked: (0, _connector_configuration_utils.ensureBooleanType)(value),
            disabled: isLoading || !hasPlatinumLicense,
            label: label,
            onChange: event => {
              validateAndSetConfigValue(event.target.checked);
            },
            "aria-label": label
          })), !hasPlatinumLicense && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_platinum_license_popover.PlatinumLicensePopover, {
            button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
              "aria-label": _i18n.i18n.translate('searchConnectors.configuration.openPopoverLabel', {
                defaultMessage: 'Open licensing popover'
              }),
              iconType: "question",
              onClick: () => setIsPopoverOpen(!isPopoverOpen)
            }),
            closePopover: () => setIsPopoverOpen(false),
            isPopoverOpen: isPopoverOpen,
            stackManagementHref: stackManagementLink,
            subscriptionLink: subscriptionLink
          })))
        });
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "row",
        gutterSize: "xs"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        checked: (0, _connector_configuration_utils.ensureBooleanType)(value),
        disabled: isLoading,
        label: label,
        onChange: event => {
          validateAndSetConfigValue(event.target.checked);
        }
      }), tooltip && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: tooltip
      })));
    default:
      return sensitive ? /*#__PURE__*/_react.default.createElement(ConfigInputPassword, {
        isLoading: isLoading,
        configEntry: configEntry,
        validateAndSetConfigValue: validateAndSetConfigValue
      }) : /*#__PURE__*/_react.default.createElement(ConfigInputField, {
        key: key,
        isLoading: isLoading,
        configEntry: configEntry,
        validateAndSetConfigValue: validateAndSetConfigValue
      });
  }
};
exports.ConnectorConfigurationField = ConnectorConfigurationField;