"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Header = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Header = ({
  canCreate,
  onCreate
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.savedObjectsTagging.management.headerTitle",
      defaultMessage: "Tags"
    }),
    bottomBorder: true,
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.savedObjectsTagging.management.headerDescription",
      defaultMessage: "Use tags to categorize and easily find your objects."
    }),
    rightSideItems: [canCreate && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      key: "createTag",
      iconType: "tag",
      color: "primary",
      fill: true,
      "data-test-subj": "createTagButton",
      onClick: onCreate,
      isDisabled: false
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.savedObjectsTagging.management.actions.createTagButton",
      defaultMessage: "Create tag"
    }))]
  });
};
exports.Header = Header;