"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TagBadge = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The badge representation of a Tag, which is the default display to be used for them.
 */
const TagBadge = ({
  tag,
  onClick
}) => {
  const onClickProps = onClick ? {
    onClick: () => {
      onClick(tag);
    },
    onClickAriaLabel: _i18n.i18n.translate('xpack.savedObjectsTagging.tagList.tagBadge.buttonLabel', {
      defaultMessage: '{tagName} tag',
      values: {
        tagName: tag.name
      }
    }),
    iconOnClick: () => undefined,
    iconOnClickAriaLabel: ''
  } : {};
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
    color: tag.color,
    title: tag.description
  }, onClickProps), tag.name);
};
exports.TagBadge = TagBadge;