"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cloneJob = void 0;
var _services = require("../../services");
var _action_types = require("../action_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cloneJob = () => next => action => {
  const {
    type
  } = action;
  if (type === _action_types.CLONE_JOB_START) {
    if (!(0, _services.getUserHasLeftApp)()) {
      (0, _services.getRouter)().history.push({
        pathname: `/create`
      });
    }
  }
  return next(action);
};
exports.cloneJob = cloneJob;