"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateIndexPattern = validateIndexPattern;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/data-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function validateIndexPattern(indexPattern, rollupIndex) {
  if (!indexPattern || !indexPattern.trim()) {
    return [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.errors.indexPatternMissing",
      defaultMessage: "Index pattern is required."
    })];
  }
  if (indexPattern === rollupIndex) {
    return [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.errors.indexPatternSameAsRollupIndex",
      defaultMessage: "Index pattern cannot have the same as the rollup index."
    })];
  }
  const illegalCharacters = _public.indexPatterns.ILLEGAL_CHARACTERS_VISIBLE.reduce((chars, char) => {
    if (indexPattern.includes(char)) {
      chars.push(char);
    }
    return chars;
  }, []);
  if (illegalCharacters.length) {
    return [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.errors.indexPatternIllegalCharacters",
      defaultMessage: "Remove the characters {characterList} from your index pattern.",
      values: {
        characterList: /*#__PURE__*/_react.default.createElement("strong", null, illegalCharacters.join(' '))
      }
    })];
  }
  if (indexPattern.includes(' ')) {
    return [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.errors.indexPatternSpaces",
      defaultMessage: "Remove the spaces from your index pattern."
    })];
  }
  return undefined;
}