"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TabHistogram = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _field_list = require("../../field_list");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const columns = [{
  field: 'name',
  name: _i18n.i18n.translate('xpack.rollupJobs.jobDetails.tabHistogram.nameColumnLabel', {
    defaultMessage: 'Field'
  }),
  sortable: true
}];
const TabHistogram = ({
  histogram,
  histogramInterval
}) => /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
  textStyle: "reverse"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.rollupJobs.jobDetails.tabHistogram.intervalLabel",
  defaultMessage: "Histogram interval"
})), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, histogramInterval)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "l"
}), /*#__PURE__*/_react.default.createElement(_field_list.FieldList, {
  columns: columns,
  fields: histogram,
  dataTestSubj: "detailPanelHistogramTabTable"
}));
exports.TabHistogram = TabHistogram;