"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.oneOfLiterals = exports.jobsSelectionSchema = exports.getComparatorSchemaType = exports.betweenComparators = exports.LEGACY_COMPARATORS = exports.ComparatorFns = exports.ComparatorFnNames = void 0;
exports.validateAggType = validateAggType;
exports.validateComparator = validateComparator;
exports.validateGroupBy = validateGroupBy;
exports.validateKQLStringFilter = exports.validateIsStringElasticsearchJSONFilter = void 0;
exports.validateKuery = validateKuery;
exports.validateTimeWindowUnits = validateTimeWindowUnits;
var _configSchema = require("@kbn/config-schema");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _esQuery = require("@kbn/es-query");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const TimeWindowUnits = new Set(['s', 'm', 'h', 'd']);
const AggTypes = new Set(['count', 'avg', 'min', 'max', 'sum']);
const betweenComparators = exports.betweenComparators = new Set(['between', 'notBetween']);
const jobsSelectionSchema = exports.jobsSelectionSchema = _configSchema.schema.object({
  jobIds: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    defaultValue: []
  }),
  groupIds: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    defaultValue: []
  })
}, {
  validate: v => {
    var _v$jobIds, _v$groupIds;
    if (!((_v$jobIds = v.jobIds) !== null && _v$jobIds !== void 0 && _v$jobIds.length) && !((_v$groupIds = v.groupIds) !== null && _v$groupIds !== void 0 && _v$groupIds.length)) {
      return _i18n.i18n.translate('xpack.ml.alertTypes.anomalyDetection.jobSelection.errorMessage', {
        defaultMessage: 'Job selection is required'
      });
    }
  }
});
const oneOfLiterals = arrayOfLiterals => _configSchema.schema.string({
  validate: value => arrayOfLiterals.includes(value) ? undefined : `must be one of ${arrayOfLiterals.join(' | ')}`
});
exports.oneOfLiterals = oneOfLiterals;
const validateIsStringElasticsearchJSONFilter = value => {
  if (value === '') {
    // Allow clearing the filter.
    return;
  }
  const errorMessage = 'filterQuery must be a valid Elasticsearch filter expressed in JSON';
  try {
    const parsedValue = JSON.parse(value);
    if (!(0, _lodash.isEmpty)(parsedValue.bool)) {
      return undefined;
    }
    return errorMessage;
  } catch (e) {
    return errorMessage;
  }
};
exports.validateIsStringElasticsearchJSONFilter = validateIsStringElasticsearchJSONFilter;
const validateKQLStringFilter = value => {
  if (value === '') {
    // Allow clearing the filter.
    return;
  }
  try {
    (0, _esQuery.buildEsQuery)(undefined, [{
      query: value,
      language: 'kuery'
    }], [], {
      allowLeadingWildcards: true,
      queryStringOptions: {},
      ignoreFilterIfFieldNotInIndex: false
    });
  } catch (e) {
    return _i18n.i18n.translate('xpack.responseOps.ruleParams.customThreshold.schema.invalidFilterQuery', {
      defaultMessage: 'filterQuery must be a valid KQL filter (error: {errorMessage})',
      values: {
        errorMessage: e === null || e === void 0 ? void 0 : e.message
      }
    });
  }
};
exports.validateKQLStringFilter = validateKQLStringFilter;
let LEGACY_COMPARATORS = exports.LEGACY_COMPARATORS = /*#__PURE__*/function (LEGACY_COMPARATORS) {
  LEGACY_COMPARATORS["OUTSIDE_RANGE"] = "outside";
  return LEGACY_COMPARATORS;
}({});
function validateTimeWindowUnits(timeWindowUnit) {
  if (TimeWindowUnits.has(timeWindowUnit)) {
    return;
  }
  return _i18n.i18n.translate('xpack.responseOps.ruleParams.coreQueryParams.invalidTimeWindowUnitsErrorMessage', {
    defaultMessage: 'invalid timeWindowUnit: "{timeWindowUnit}"',
    values: {
      timeWindowUnit
    }
  });
}
function validateAggType(aggType) {
  if (AggTypes.has(aggType)) {
    return;
  }
  return _i18n.i18n.translate('xpack.responseOps.ruleParams.data.coreQueryParams.invalidAggTypeErrorMessage', {
    defaultMessage: 'invalid aggType: "{aggType}"',
    values: {
      aggType
    }
  });
}
function validateGroupBy(groupBy) {
  if (groupBy === 'all' || groupBy === 'top' || groupBy === 'row') {
    return;
  }
  return _i18n.i18n.translate('xpack.responseOps.ruleParams.coreQueryParams.invalidGroupByErrorMessage', {
    defaultMessage: 'invalid groupBy: "{groupBy}"',
    values: {
      groupBy
    }
  });
}
const ComparatorFns = exports.ComparatorFns = new Map([[_constants.Comparator.LT, (value, threshold) => value < threshold[0]], [_constants.Comparator.LT_OR_EQ, (value, threshold) => value <= threshold[0]], [_constants.Comparator.GT_OR_EQ, (value, threshold) => value >= threshold[0]], [_constants.Comparator.GT, (value, threshold) => value > threshold[0]], [_constants.Comparator.BETWEEN, (value, threshold) => value >= threshold[0] && value <= threshold[1]], [_constants.Comparator.NOT_BETWEEN, (value, threshold) => value < threshold[0] || value > threshold[1]]]);
const getComparatorSchemaType = validate => _configSchema.schema.oneOf([_configSchema.schema.literal(_constants.Comparator.GT), _configSchema.schema.literal(_constants.Comparator.LT), _configSchema.schema.literal(_constants.Comparator.GT_OR_EQ), _configSchema.schema.literal(_constants.Comparator.LT_OR_EQ), _configSchema.schema.literal(_constants.Comparator.BETWEEN), _configSchema.schema.literal(_constants.Comparator.NOT_BETWEEN)], {
  validate,
  meta: {
    description: 'The comparison function for the threshold. For example: greater than, less than, greater than or equal to, between, or not between.'
  }
});
exports.getComparatorSchemaType = getComparatorSchemaType;
const ComparatorFnNames = exports.ComparatorFnNames = new Set(ComparatorFns.keys());
function validateKuery(query) {
  try {
    (0, _esQuery.toElasticsearchQuery)((0, _esQuery.fromKueryExpression)(query));
  } catch (e) {
    return _i18n.i18n.translate('xpack.responseOps.ruleParams.coreQueryParams.invalidKQLQueryErrorMessage', {
      defaultMessage: 'Filter query is invalid.'
    });
  }
}
function validateComparator(comparator) {
  if (ComparatorFnNames.has(comparator)) return;
  return _i18n.i18n.translate('xpack.responseOps.ruleParams.invalidComparatorErrorMessage', {
    defaultMessage: 'invalid thresholdComparator specified: {comparator}',
    values: {
      comparator
    }
  });
}