/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */(()=>{var e,t={859:(e,t,r)=>{"use strict";r.d(t,{A1:()=>g,CB:()=>o,Cd:()=>n,Ez:()=>u,Gq:()=>d,Pm:()=>p,Zw:()=>l,fW:()=>s,pY:()=>h,xR:()=>i,xU:()=>c});var a=r(1403);const i=["trial","standard","gold","platinum","enterprise"],s="xpack.reporting.jobCompletionNotifications",o=[a.T,a.ii,a.gi,a.w5,a.EF],n="/app/reportingRedirect",l="__REPORTING_REDIRECT_LOCATOR_STORE_KEY__",c="/app/management/insightsAndAlerting/reporting",d="/app/management/insightsAndAlerting/reporting/schedules",u="kibana-reporting";let p=function(e){return e.PENDING="pending",e.PROCESSING="processing",e.COMPLETED="completed",e.FAILED="failed",e.WARNINGS="completed_with_warnings",e}({});const g="reportJobListing",h="reportJobRow"},7023:(e,t,r)=>{"use strict";r.d(t,{zf:()=>VisualReportingSoftDisabledError});var a=r(8915),i=r(5008);class ReportingError extends Error{constructor(e){super(),this.details=e}get message(){const e="ReportingError";return this.details?`${e}(code: ${this.code}) "${this.details}"`:`${e}(code: ${this.code})`}toString(){return this.message}}class InvalidLayoutParametersError extends ReportingError{get code(){return InvalidLayoutParametersError.code}}(0,a.default)(InvalidLayoutParametersError,"code","invalid_layout_parameters_error");class DisallowedOutgoingUrl extends ReportingError{get code(){return DisallowedOutgoingUrl.code}}(0,a.default)(DisallowedOutgoingUrl,"code","disallowed_outgoing_url_error");class AuthenticationExpiredError extends ReportingError{get code(){return AuthenticationExpiredError.code}}(0,a.default)(AuthenticationExpiredError,"code","authentication_expired_error");class MissingAuthenticationError extends ReportingError{get code(){return MissingAuthenticationError.code}}(0,a.default)(MissingAuthenticationError,"code","missing_authentication_header_error");class QueueTimeoutError extends ReportingError{get code(){return QueueTimeoutError.code}}(0,a.default)(QueueTimeoutError,"code","queue_timeout_error");class UnknownError extends ReportingError{get code(){return UnknownError.code}}(0,a.default)(UnknownError,"code","unknown_error");class PdfWorkerOutOfMemoryError extends ReportingError{get code(){return PdfWorkerOutOfMemoryError.code}humanFriendlyMessage(){return i.i18n.translate("reporting.common.pdfWorkerOutOfMemoryErrorMessage",{defaultMessage:"Can't generate a PDF due to insufficient memory. Try making a smaller PDF and retrying this report."})}}(0,a.default)(PdfWorkerOutOfMemoryError,"code","pdf_worker_out_of_memory_error");class BrowserCouldNotLaunchError extends ReportingError{get code(){return BrowserCouldNotLaunchError.code}humanFriendlyMessage(){return i.i18n.translate("reporting.common.browserCouldNotLaunchErrorMessage",{defaultMessage:"Can't generate screenshots because the browser did not launch. See the server logs for more information."})}}(0,a.default)(BrowserCouldNotLaunchError,"code","browser_could_not_launch_error");class BrowserUnexpectedlyClosedError extends ReportingError{get code(){return BrowserUnexpectedlyClosedError.code}}(0,a.default)(BrowserUnexpectedlyClosedError,"code","browser_unexpectedly_closed_error");class BrowserScreenshotError extends ReportingError{get code(){return BrowserScreenshotError.code}}(0,a.default)(BrowserScreenshotError,"code","browser_screenshot_error");class KibanaShuttingDownError extends ReportingError{get code(){return KibanaShuttingDownError.code}}(0,a.default)(KibanaShuttingDownError,"code","kibana_shutting_down_error");class VisualReportingSoftDisabledError extends ReportingError{get code(){return VisualReportingSoftDisabledError.code}humanFriendlyMessage(){return i.i18n.translate("reporting.common.cloud.insufficientSystemMemoryError",{defaultMessage:"Can't generate this report due to insufficient memory."})}}(0,a.default)(VisualReportingSoftDisabledError,"code","visual_reporting_soft_disabled_error")},6743:(e,t,r)=>{"use strict";r.d(t,{Ez:()=>a.Ez,lJ:()=>n,fW:()=>a.fW,Pm:()=>a.Pm,Ff:()=>c,xU:()=>a.xU,Gq:()=>a.Gq,CB:()=>a.CB,Cd:()=>a.Cd,Zw:()=>a.Zw,A1:()=>a.A1,pY:()=>a.pY,xR:()=>a.xR,yc:()=>s,l6:()=>i});var a=r(859);r(7023),r(1783);const i=e=>"number"==typeof e?e:e.asMilliseconds();r(8915),r(770);const s=({basePath:e,appPath:t,spaceId:r})=>void 0===r||"default"===r.toLowerCase()?`${e}${t}`:`${e}/s/${r}${t}`,o="/internal/reporting",n={MIGRATE:{MIGRATE_ILM_POLICY:o+"/deprecations/migrate_ilm_policy",GET_ILM_POLICY_STATUS:o+"/ilm_policy_status"},DIAGNOSE:{BROWSER:o+"/diagnose/browser",SCREENSHOT:o+"/diagnose/screenshot"},JOBS:{COUNT:o+"/jobs/count",LIST:o+"/jobs/list",INFO_PREFIX:o+"/jobs/info",DELETE_PREFIX:o+"/jobs/delete",DOWNLOAD_PREFIX:o+"/jobs/download"},DOWNLOAD_CSV:o+"/generate/immediate/csv_searchsource",SCHEDULED:{LIST:o+"/scheduled/list",BULK_DISABLE:o+"/scheduled/bulk_disable"},HEALTH:o+"/_health",GENERATE_PREFIX:o+"/generate",SCHEDULE_PREFIX:o+"/schedule"},l="/api/reporting",c={GENERATE_PREFIX:l+"/generate",JOBS:{DOWNLOAD_PREFIX:l+"/jobs/download",DELETE_PREFIX:l+"/jobs/delete"}}},1485:(e,t,r)=>{"use strict";r.d(t,{wn:()=>a,tE:()=>s,By:()=>c,lV:()=>i,y:()=>o,ah:()=>l});const a="csv_searchsource",i="csv_searchsource",s="csv_v2",o="csv_v2";var n=r(6743);const l=(e,{scroll:t},r)=>(e.setField("size",(0,n.l6)(t.size)),e.setField("timeout",t.duration),e.setField("trackTotalHits",!0),r&&e.setField("pit",{id:r,keep_alive:t.duration}),{requestBody:e.getSearchRequestBody()}),c="generateCsvReport"},7519:(e,t,r)=>{"use strict";r.d(t,{cU:()=>i,dn:()=>a});const a="printable_pdf_v2",i="printablePdfV2"},8628:(e,t,r)=>{"use strict";r.d(t,{F:()=>a,Y:()=>i});const a="pngV2",i="PNGV2"},2986:(e,t,r)=>{"use strict";r.r(t),r.d(t,{InternalApiClientProvider:()=>j,Job:()=>Job,ReportingAPIClient:()=>ReportingAPIClient,checkLicense:()=>k.q,jobCompletionNotifications:()=>S,useCheckIlmPolicyStatus:()=>P,useInternalApiClient:()=>w,useKibana:()=>O});var a=r(8915),i=r(1783),s=r.n(i),o=r(4286),n=r.n(o),l=r(1319),c=r(5008),d=r(6743),u=r(1485),p=r(7519),g=r(8628),h=r(6791);u.wn,u.tE,p.dn,g.Y;const{COMPLETED:f,FAILED:m,PENDING:b,PROCESSING:v,WARNINGS:y}=d.Pm;class Job{constructor(e){var t,r,i,s,o,n;(0,a.default)(this,"payload",void 0),(0,a.default)(this,"id",void 0),(0,a.default)(this,"index",void 0),(0,a.default)(this,"objectType",void 0),(0,a.default)(this,"title",void 0),(0,a.default)(this,"isDeprecated",void 0),(0,a.default)(this,"spaceId",void 0),(0,a.default)(this,"browserTimezone",void 0),(0,a.default)(this,"layout",void 0),(0,a.default)(this,"pagingStrategy",void 0),(0,a.default)(this,"version",void 0),(0,a.default)(this,"jobtype",void 0),(0,a.default)(this,"created_by",void 0),(0,a.default)(this,"created_at",void 0),(0,a.default)(this,"started_at",void 0),(0,a.default)(this,"completed_at",void 0),(0,a.default)(this,"status",void 0),(0,a.default)(this,"attempts",void 0),(0,a.default)(this,"max_attempts",void 0),(0,a.default)(this,"timeout",void 0),(0,a.default)(this,"kibana_name",void 0),(0,a.default)(this,"kibana_id",void 0),(0,a.default)(this,"size",void 0),(0,a.default)(this,"content_type",void 0),(0,a.default)(this,"csv_contains_formulas",void 0),(0,a.default)(this,"max_size_reached",void 0),(0,a.default)(this,"metrics",void 0),(0,a.default)(this,"warnings",void 0),(0,a.default)(this,"error_code",void 0),(0,a.default)(this,"locatorParams",void 0),(0,a.default)(this,"queue_time_ms",void 0),(0,a.default)(this,"execution_time_ms",void 0),(0,a.default)(this,"scheduled_report_id",void 0),this.id=e.id,this.index=e.index,this.payload=e.payload,this.jobtype=e.jobtype,this.objectType=e.payload.objectType,this.title=e.payload.title,this.layout=e.payload.layout,this.pagingStrategy=e.payload.pagingStrategy,this.version=e.payload.version,this.created_by=e.created_by,this.created_at=e.created_at,this.started_at=e.started_at,this.completed_at=e.completed_at,this.status=e.status,this.attempts=e.attempts,this.max_attempts=e.max_attempts,this.timeout=e.timeout,this.kibana_name=e.kibana_name,this.kibana_id=e.kibana_id,this.browserTimezone=e.payload.browserTimezone,this.size=null===(t=e.output)||void 0===t?void 0:t.size,this.content_type=null===(r=e.output)||void 0===r?void 0:r.content_type,this.isDeprecated=e.payload.isDeprecated||!1,this.spaceId=e.payload.spaceId,this.csv_contains_formulas=null===(i=e.output)||void 0===i?void 0:i.csv_contains_formulas,this.max_size_reached=null===(s=e.output)||void 0===s?void 0:s.max_size_reached,this.warnings=null===(o=e.output)||void 0===o?void 0:o.warnings,this.error_code=null===(n=e.output)||void 0===n?void 0:n.error_code,this.locatorParams=e.payload.locatorParams,this.metrics=e.metrics,this.queue_time_ms=e.queue_time_ms,this.execution_time_ms=e.execution_time_ms,this.scheduled_report_id=e.scheduled_report_id}isSearch(){return"search"===this.objectType}getStatusMessage(){const e=this.status;let t,r;return e===b?t=c.i18n.translate("reporting.jobStatusDetail.pendingStatusReachedText",{defaultMessage:"Waiting for job to process."}):e===v?t=c.i18n.translate("reporting.jobStatusDetail.attemptXofY",{defaultMessage:"Attempt {attempts} of {max_attempts}.",values:{attempts:this.attempts,max_attempts:this.max_attempts}}):this.getWarnings()?t=c.i18n.translate("reporting.jobStatusDetail.warningsText",{defaultMessage:"See report info for warnings."}):this.getError()&&(t=c.i18n.translate("reporting.jobStatusDetail.errorText",{defaultMessage:"See report info for error details."})),this.isDeprecated&&(r=(0,h.jsx)(l.EuiText,{size:"s"}," ",(0,h.jsx)(l.EuiTextColor,{color:"warning"},c.i18n.translate("reporting.jobStatusDetail.deprecatedText",{defaultMessage:"This is a deprecated export type. Automation of this report will need to be re-created for compatibility with future versions of Kibana."})))),t?(0,h.jsx)(n().Fragment,null,(0,h.jsx)(l.EuiText,{size:"s"},(0,h.jsx)(l.EuiTextColor,{color:"subdued"},t)),r||null):null}get prettyStatus(){var e;return null!==(e=_.get(this.status))&&void 0!==e?e:c.i18n.translate("reporting.jobStatusDetail.unknownText",{defaultMessage:"Unknown"})}get canLinkToKibanaApp(){return Boolean(this.locatorParams)}get isDownloadReady(){return this.status===d.Pm.COMPLETED||this.status===d.Pm.WARNINGS}get prettyJobTypeName(){switch(this.jobtype){case"printable_pdf":case"printable_pdf_v2":return c.i18n.translate("reporting.jobType.pdfOutputName",{defaultMessage:"PDF"});case"PNG":case"PNGV2":return c.i18n.translate("reporting.jobType.pngOutputName",{defaultMessage:"PNG"});case"csv_v2":case"csv_searchsource":return c.i18n.translate("reporting.jobType.csvOutputName",{defaultMessage:"CSV"});default:return}}get prettyTimeout(){if(null==this.timeout)return c.i18n.translate("reporting.jobStatusDetail.timeoutSecondsUnknown",{defaultMessage:"Unknown"});const e=this.timeout/1e3;return c.i18n.translate("reporting.jobStatusDetail.timeoutSeconds",{defaultMessage:"{timeout} seconds",values:{timeout:e}})}getCreatedAtDate(){return this.formatDate(this.created_at)}getCreatedBy(){return this.created_by||c.i18n.translate("reporting.jobCreatedBy.unknownUserPlaceholderText",{defaultMessage:"Unknown"})}getCreatedAtLabel(){return this.created_by?(0,h.jsx)(n().Fragment,null,(0,h.jsx)("div",null,this.formatDate(this.created_at)),(0,h.jsx)("span",null,this.created_by)):this.formatDate(this.created_at)}getError(){if(this.status===m)return this.warnings}getDeprecatedMessage(){if(this.isDeprecated)return c.i18n.translate("reporting.jobWarning.exportTypeDeprecated",{defaultMessage:"This is a deprecated export type. Automation of this report will need to be re-created for compatibility with future versions of Kibana."})}getWarnings(){var e;const t=[],r=this.getDeprecatedMessage();if(r&&t.push(r),this.csv_contains_formulas&&t.push(c.i18n.translate("reporting.jobWarning.csvContainsFormulas",{defaultMessage:"Your CSV contains characters that spreadsheet applications might interpret as formulas."})),this.max_size_reached&&t.push(c.i18n.translate("reporting.jobWarning.maxSizeReachedTooltip",{defaultMessage:"Your search reached the max size and contains partial data."})),this.status!==m&&null!==(e=this.warnings)&&void 0!==e&&e.length&&t.push(...this.warnings),t.length)return(0,h.jsx)("ul",null,t.map(((e,t)=>(0,h.jsx)("li",{key:`warning-key-${t}`},e))))}getPrettyStatusTimestamp(){return this.formatDate(this.getStatusTimestamp())}formatDate(e){try{return s()(e).format("YYYY-MM-DD @ hh:mm A")}catch(t){return e}}getStatusTimestamp(){const e=this.status;return e===v&&this.started_at?this.started_at:this.completed_at&&[f,m,y].includes(e)?this.completed_at:this.created_at}}const _=new Map([[b,c.i18n.translate("reporting.jobStatuses.pendingText",{defaultMessage:"Pending"})],[v,c.i18n.translate("reporting.jobStatuses.processingText",{defaultMessage:"Processing"})],[f,c.i18n.translate("reporting.jobStatuses.completedText",{defaultMessage:"Completed"})],[y,c.i18n.translate("reporting.jobStatuses.warningText",{defaultMessage:"Completed"})],[m,c.i18n.translate("reporting.jobStatuses.failedText",{defaultMessage:"Failed"})]]);function S(){return{getPendingJobIds:function(){const e=[];for(const t in localStorage)if(0===t.indexOf(d.fW)){const r=t.replace(`${d.fW}-`,"");e.push(r)}return e},addPendingJobId:function(e){localStorage.setItem(`${d.fW}-${e}`,e)},setPendingJobIds:function(e){for(const e in localStorage)0===e.indexOf(d.fW)&&localStorage.removeItem(e);for(let t=0;t<e.length;t++){const r=e[t];localStorage.setItem(`${d.fW}-${r}`,r)}}}}const x=(0,o.createContext)(void 0),j=({apiClient:e,http:t,children:r})=>(0,h.jsx)(x.Provider,{value:{http:t,apiClient:e}},r),w=()=>{const e=(0,o.useContext)(x);if(!e)throw new Error('"useInternalApiClient" can only be used inside of "InternalApiClientContext"');return e};var E=r(8744);const P=()=>{const{services:{http:e}}=O();return(0,E.useRequest)(e,{path:d.lJ.MIGRATE.GET_ILM_POLICY_STATUS,method:"get"})};var C=r(5995),R=r.n(C),T=r(151),M=r(3721);class ReportingAPIClient{constructor(e,t,r){(0,a.default)(this,"http",void 0),(0,a.default)(this,"addPendingJobId",S().addPendingJobId),(0,a.default)(this,"getManagementLink",(()=>this.http.basePath.prepend(d.xU))),(0,a.default)(this,"getDownloadLink",(e=>this.getReportURL(e))),(0,a.default)(this,"getServerBasePath",(()=>this.http.basePath.serverBasePath)),this.uiSettings=t,this.kibanaVersion=r,this.http=e}getKibanaAppHref(e){const t=(0,T.stringify)({jobId:e.id,...e.scheduled_report_id?{scheduledReportId:e.scheduled_report_id}:{}});return`${(0,d.yc)({basePath:this.http.basePath.serverBasePath,spaceId:e.spaceId,appPath:d.Cd})}?${t}`}getReportURL(e){return this.http.basePath.prepend(`${d.lJ.JOBS.DOWNLOAD_PREFIX}/${e}?elasticInternalOrigin=true`)}downloadReport(e){const t=this.getReportURL(e);window.open(t)}async deleteReport(e){return await this.http.delete(`${d.lJ.JOBS.DELETE_PREFIX}/${e}`)}async list(e=0,t=50,r=[]){const a={page:e,size:t};return r.length>0&&(a.ids=r.slice(0,t).join(",")),(await this.http.get(d.lJ.JOBS.LIST,{query:a,asSystemRequest:!0})).map((e=>new Job(e)))}async total(){return await this.http.get(d.lJ.JOBS.COUNT,{asSystemRequest:!0})}async getError(e){var t;const r=await this.getInfo(e);return null!==(t=r.warnings)&&void 0!==t&&t[0]?r.warnings[0]:c.i18n.translate("reporting.apiClient.unknownError",{defaultMessage:"Report job {job} failed. Error unknown.",values:{job:e}})}async getInfo(e){const t=await this.http.get(`${d.lJ.JOBS.INFO_PREFIX}/${e}`);return new Job(t)}async getScheduledReportInfo(e,t=0,r=50){const{data:a=[]}=await this.http.get(`${d.lJ.SCHEDULED.LIST}`,{query:{page:t,size:r}});return a.find((t=>t.id===e))}async findForJobIds(e){return(await this.http.fetch(d.lJ.JOBS.LIST,{query:{page:0,ids:e.join(",")},method:"GET"})).map((e=>new Job(e)))}getReportingPublicJobPath(e,t){const r=(0,T.stringify)({jobParams:R().encode(t)});return`${this.http.basePath.prepend(d.Ff.GENERATE_PREFIX)}/${e}?${r}`}async createReportingShareJob(e,t){const r=R().encode(t),a=await this.http.post(`${d.lJ.GENERATE_PREFIX}/${e}`,{method:"POST",body:JSON.stringify({jobParams:r})});if(null!=a&&a.job)return this.addPendingJobId(a.job.id),new Job(a.job)}async createReportingJob(e,t){const r=R().encode(t);try{const t=await this.http.post(`${d.lJ.GENERATE_PREFIX}/${e}`,{method:"POST",body:JSON.stringify({jobParams:r})});if(null!=t&&t.job)return this.addPendingJobId(t.job.id),new Job(t.job)}catch(e){var a;throw M.error(e),new Error(`${null===(a=e.body)||void 0===a?void 0:a.message}`)}}async createImmediateReport(e){const{objectType:t,...r}=e;return this.http.post(d.lJ.DOWNLOAD_CSV,{asResponse:!0,body:JSON.stringify(r)})}getDecoratedJobParams(e){return{browserTimezone:"Browser"===this.uiSettings.get("dateFormat:tz")?s().tz.guess():this.uiSettings.get("dateFormat:tz"),version:this.kibanaVersion,...e}}verifyBrowser(){return this.http.get(d.lJ.DIAGNOSE.BROWSER)}verifyScreenCapture(){return this.http.post(d.lJ.DIAGNOSE.SCREENSHOT)}migrateReportingIndicesIlmPolicy(){return this.http.put(d.lJ.MIGRATE.MIGRATE_ILM_POLICY)}}var k=r(5190),D=r(409);const O=()=>(0,D.useKibana)()},5190:(e,t,r)=>{"use strict";r.d(t,{q:()=>a});const a=e=>{switch(e.state){case"valid":default:return{showLinks:!0,enableLinks:!0,message:""};case"invalid":return{showLinks:!1,enableLinks:!1,message:"Your license does not support Reporting. Please upgrade your license."};case"unavailable":return{showLinks:!0,enableLinks:!1,message:"You cannot use Reporting because license information is not available at this time."};case"expired":return{showLinks:!0,enableLinks:!1,message:"You cannot use Reporting because your license has expired."}}}},73:(e,t,r)=>{"use strict";r.d(t,{X:()=>d,u:()=>u});var a=r(5008),i=r(5228),s=(r(4286),r(190)),o=r(5879),n=r(1663),l=r(2986),c=r(6791);const d=({sharingData:e,forShareUrl:t=!1})=>{const r=e.getSearchSource;return e.isTextBased?{isEsqlMode:!0,locatorParams:e.locatorParams}:{isEsqlMode:!1,columns:e.columns,searchSource:r({addGlobalTimeFilter:!0,absoluteTime:!t})}},u=({apiClient:e,usesUiCapabilities:t,startServices$:r})=>({shareType:"integration",id:"csvReports",groupId:"export",config:({objectType:t,sharingData:l})=>{const u=e=>d({sharingData:l,forShareUrl:e}),p=a.i18n.translate("reporting.share.contextMenu.export.csvReportsButtonLabel",{defaultMessage:"Export"}),{reportType:g,decoratedJobParams:h}=(0,n.U)({apiClient:e,searchModeParams:u(!0),title:l.title}),f=e.getReportingPublicJobPath(g,h),m=new URL(f,window.location.href).toString();return{name:p,exportType:g,label:"CSV",icon:"tableDensityNormal",generateAssetExport:({intl:a})=>{const{reportType:d,decoratedJobParams:p}=(0,n.U)({apiClient:e,searchModeParams:u(!1),title:l.title});return(0,s.firstValueFrom)(r).then((([r])=>{const{notifications:{toasts:s},rendering:n}=r;return e.createReportingShareJob(d,p).then((()=>{s.addSuccess({title:a.formatMessage({id:"reporting.share.modalContent.successfullyQueuedReportNotificationTitle",defaultMessage:"Queued report for {objectType}"},{objectType:t}),text:(0,i.Pv)((0,c.jsx)(o.FormattedMessage,{id:"reporting.share.modalContent.successfullyQueuedReportNotificationDescription",defaultMessage:"Track its progress in {path}.",values:{path:(0,c.jsx)("a",{href:e.getManagementLink()},(0,c.jsx)(o.FormattedMessage,{id:"reporting.share.publicNotifier.reportLink.reportingSectionUrlLinkLabel",defaultMessage:"Stack Management > Reporting"}))}}),n),"data-test-subj":"queueReportSuccess"})})).catch((e=>{var t;s.addError(e,{title:a.formatMessage({id:"reporting.share.modalContent.notification.reportingErrorTitle",defaultMessage:"Unable to create report"}),toastMessage:(0,c.jsx)("span",{dangerouslySetInnerHTML:{__html:null===(t=e.body)||void 0===t?void 0:t.message}})})}))}))},helpText:(0,c.jsx)(o.FormattedMessage,{id:"reporting.share.csv.reporting.helpTextCSV",defaultMessage:"Export a CSV of this {objectType}.",values:{objectType:t}}),generateExportButtonLabel:(0,c.jsx)(o.FormattedMessage,{id:"reporting.share.generateButtonLabelCSV","data-test-subj":"generateReportButton",defaultMessage:"Generate CSV"}),copyAssetURIConfig:{headingText:a.i18n.translate("reporting.export.csv.exportFlyout.csvExportCopyUriHeading",{defaultMessage:"Post URL"}),helpText:a.i18n.translate("reporting.export.csv.exportFlyout.csvExportCopyUriHelpText",{defaultMessage:"Allows to generate selected file format programmatically outside Kibana or in Watcher."}),contentType:"text",generateAssetURIValue:()=>m}}},prerequisiteCheck:({license:e,capabilities:r})=>{if(!e)return!1;const a=(0,l.checkLicense)(e.check("reporting","basic")).showLinks;let i=!1;var s;return i=!t||!0===(null===(s=r.discover)||void 0===s?void 0:s.generateCsv),!(!a||!i)}})},3467:(e,t,r)=>{"use strict";r.d(t,{De:()=>u,TG:()=>h,af:()=>g,u5:()=>d});var a=r(5008),i=r(5879),s=r(5228),o=(r(4286),r(190)),n=r(5190),l=r(6791);const c=e=>{const t=document.querySelector("[data-shared-items-container]"),{height:r,width:a}=t?t.getBoundingClientRect():{height:768,width:1024};return{objectType:e,layout:{id:"preserve_layout",dimensions:{height:r,width:a}}}},d=({sharingData:e})=>({...c("pngV2"),locatorParams:e.locatorParams}),u=({sharingData:e,optimizedForPrinting:t=!1})=>{const r={...c("printablePdfV2"),locatorParams:[e.locatorParams]};return t&&(r.layout.id="print"),r},p=(e,t)=>()=>{const{objectType:r,sharingData:a,optimizedForPrinting:i}=e;let s;return s="pngV2"===t?d({sharingData:a}):u({sharingData:a,optimizedForPrinting:i}),{...s,objectType:r,title:a.title}},g=({apiClient:e,usesUiCapabilities:t,startServices$:r})=>{const c=["dashboard","visualization","lens"];return{id:"pdfReports",shareType:"integration",groupId:"export",config:({objectType:t,objectId:n,isDirty:c,onClose:d,shareableUrl:u,shareableUrlForSavedObject:g,...h})=>{const{sharingData:f}=h,m={shareableUrl:c?u:null!=g?g:u,objectType:t,sharingData:f},b=null===f.locatorParams;return{name:a.i18n.translate("reporting.shareContextMenu.ExportsButtonLabel",{defaultMessage:"PDF"}),icon:"document",disabled:f.reportingDisabled,label:"PDF",generateAssetExport:({intl:a,optimizedForPrinting:n=!1})=>{const c=e.getDecoratedJobParams({...p({...m,optimizedForPrinting:n},"printablePdfV2")()});return(0,o.firstValueFrom)(r).then((([r])=>{const{notifications:{toasts:o},rendering:n}=r;return e.createReportingJob("printablePdfV2",c).then((()=>{o.addSuccess({title:a.formatMessage({id:"reporting.share.modalContent.successfullyQueuedReportNotificationTitle",defaultMessage:"Queued report for {objectType}"},{objectType:t}),text:(0,s.Pv)((0,l.jsx)(i.FormattedMessage,{id:"reporting.share.modalContent.successfullyQueuedReportNotificationDescription",defaultMessage:"Track its progress in {path}.",values:{path:(0,l.jsx)("a",{href:e.getManagementLink()},(0,l.jsx)(i.FormattedMessage,{id:"reporting.share.publicNotifier.reportLink.reportingSectionUrlLinkLabel",defaultMessage:"Stack Management > Reporting"}))}}),n),"data-test-subj":"queueReportSuccess"})})).catch((e=>{var t;o.addError(e,{title:a.formatMessage({id:"reporting.share.modalContent.notification.reportingErrorTitle",defaultMessage:"Unable to create report"}),toastMessage:null===(t=e.body)||void 0===t?void 0:t.message})}))}))},exportType:"printablePdfV2",requiresSavedState:b,renderLayoutOptionSwitch:"dashboard"===t,copyAssetURIConfig:{headingText:a.i18n.translate("reporting.shareContextMenu.copyUriModal.pdfExportCopyUriHeading",{defaultMessage:"Post URL"}),helpText:a.i18n.translate("reporting.shareContextMenu.copyUriModal.pdfExportCopyUriHelpText",{defaultMessage:"Allows to generate selected file format programmatically outside Kibana or in Watcher."}),contentType:"text",generateAssetURIValue:({optimizedForPrinting:t})=>{const r=e.getDecoratedJobParams(p({...m,optimizedForPrinting:t},"printablePdfV2")()),a=e.getReportingPublicJobPath("printablePdfV2",r);return new URL(a,window.location.href).toString()}}}},prerequisiteCheck({license:e,capabilities:r,objectType:a}){if(!e)return!1;let i;if(!(i=c.includes(a)))return!1;const{showLinks:s}=(0,n.q)(e.check("reporting","gold"));let o=!1,l=!1;var d,u;return t?(o=!0===(null===(d=r.dashboard)||void 0===d?void 0:d.generateScreenshot),l=!0===(null===(u=r.visualize)||void 0===u?void 0:u.generateScreenshot)):(o=!0,l=!0),!(!s||"dashboard"===a&&!o||i&&!l&&!o)}}},h=({apiClient:e,usesUiCapabilities:t,startServices$:r})=>{const c=["dashboard","visualization","lens"];return{shareType:"integration",groupId:"export",id:"imageReports",config:({objectType:t,objectId:n,isDirty:c,onClose:d,shareableUrl:u,shareableUrlForSavedObject:g,...h})=>{const{sharingData:f}=h,m={shareableUrl:c?u:null!=g?g:u,objectType:t,sharingData:f},b=null===f.locatorParams;return{name:a.i18n.translate("reporting.shareContextMenu.ExportsButtonLabelPNG",{defaultMessage:"PNG export"}),icon:"image",disabled:f.reportingDisabled,label:"PNG",generateAssetExport:({intl:a})=>{const n=e.getDecoratedJobParams({...p(m,"pngV2")()});return(0,o.firstValueFrom)(r).then((([r])=>{const{notifications:{toasts:o},rendering:c}=r;return e.createReportingJob("pngV2",n).then((()=>{o.addSuccess({title:a.formatMessage({id:"reporting.share.modalContent.successfullyQueuedReportNotificationTitle",defaultMessage:"Queued report for {objectType}"},{objectType:t}),text:(0,s.Pv)((0,l.jsx)(i.FormattedMessage,{id:"reporting.share.modalContent.successfullyQueuedReportNotificationDescription",defaultMessage:"Track its progress in {path}.",values:{path:(0,l.jsx)("a",{href:e.getManagementLink()},(0,l.jsx)(i.FormattedMessage,{id:"reporting.share.publicNotifier.reportLink.reportingSectionUrlLinkLabel",defaultMessage:"Stack Management > Reporting"}))}}),c),"data-test-subj":"queueReportSuccess"})})).catch((e=>{var t;o.addError(e,{title:a.formatMessage({id:"reporting.share.modalContent.notification.reportingErrorTitle",defaultMessage:"Unable to create report"}),toastMessage:null===(t=e.body)||void 0===t?void 0:t.message})}))}))},exportType:"pngV2",requiresSavedState:b,copyAssetURIConfig:{headingText:a.i18n.translate("reporting.shareContextMenu.copyUriModal.pngExportCopyUriHeading",{defaultMessage:"Post URL"}),helpText:a.i18n.translate("reporting.shareContextMenu.copyUriModal.pngExportCopyUriHelpText",{defaultMessage:"Allows to generate selected file format programmatically outside Kibana or in Watcher."}),contentType:"text",generateAssetURIValue:()=>{const t=e.getDecoratedJobParams(p(m,"pngV2")()),r=e.getReportingPublicJobPath("pngV2",t);return new URL(r,window.location.href).toString()}}}},prerequisiteCheck({license:e,capabilities:r,objectType:a}){if(!e)return!1;let i;if(!(i=c.includes(a)))return!1;const{showLinks:s}=(0,n.q)(e.check("reporting","gold")),o=s;let l=!1,d=!1;var u,p;return t?(l=!0===(null===(u=r.dashboard)||void 0===u?void 0:u.generateScreenshot),d=!0===(null===(p=r.visualize)||void 0===p?void 0:p.generateScreenshot)):(l=!0,d=!0),!(!o||"dashboard"===a&&!l||i&&!d&&!l)}}}},1663:(e,t,r)=>{"use strict";r.d(t,{U:()=>i});var a=r(1485);const i=({apiClient:e,searchModeParams:t,title:r})=>{const i=t.isEsqlMode?a.tE:a.wn,s={title:r,objectType:"search"};return t.isEsqlMode?{reportType:i,decoratedJobParams:e.getDecoratedJobParams({...s,locatorParams:t.locatorParams})}:{reportType:i,decoratedJobParams:e.getDecoratedJobParams({...s,columns:t.columns,searchSource:t.searchSource})}}},1403:(e,t,r)=>{"use strict";r.d(t,{EF:()=>n,T:()=>a,gi:()=>s,ii:()=>i,w5:()=>o});const a="DISCOVER_APP_LOCATOR",i="CANVAS_APP_LOCATOR",s="DASHBOARD_APP_LOCATOR",o="LENS_APP_LOCATOR",n="VISUALIZE_APP_LOCATOR"},5228:(e,t,r)=>{"use strict";r.d(t,{Pv:()=>l});var a=r(482),i=r(4286),s=r(2874),o=r.n(s),n=r(6791);const l=(e,t)=>{let r;return r=function(e){return void 0!==e&&void 0!==e.addContext}(t)?r=>(o().render(t.addContext(e),r),()=>o().unmountComponentAtNode(r)):r=>(o().render((0,n.jsx)(a.KibanaRenderContextProvider,t,e),r),()=>o().unmountComponentAtNode(r)),r};r(8915),r(5008),i.Component},4023:(e,t,r)=>{"use strict";r.d(t,{Cf:()=>s,ZE:()=>i,y1:()=>a});const a="/app/management/insightsAndAlerting/reporting",i="/exports",s="/schedules"},8831:(e,t,r)=>{"use strict";r.r(t),r.d(t,{plugin:()=>H});var a=r(8915),i=r(190),s=r(7546),o=r(5008),n=r(6743),l=r(2986),c=r(3467),d=r(73),u=r(3185),p=r(4286),g=r.n(p),h=r(7519),f=r(8628),m=r(1319),b=r(6791);const v=()=>(0,b.jsx)(p.Fragment,null,(0,b.jsx)(m.EuiSpacer,null),(0,b.jsx)(m.EuiFlexGroup,{justifyContent:"spaceAround"},(0,b.jsx)(m.EuiFlexItem,{grow:!1},(0,b.jsx)(m.EuiLoadingSpinner,{size:"l"}))),(0,b.jsx)(m.EuiSpacer,null)),y=(0,p.lazy)((()=>r.e(604).then(r.bind(r,3604)).then((({ScreenCapturePanelContent:e})=>({default:e}))))),_=e=>(0,b.jsx)(p.Suspense,{fallback:(0,b.jsx)(v,null)},(0,b.jsx)(y,e));function S(e,t){return{ReportingPanelPDFV2:r=>"canvas"===r.layoutOption?(0,b.jsx)(_,(0,u.default)({requiresSavedState:!1,reportType:h.cU,apiClient:e,layoutOption:"canvas",startServices$:t},r)):null,ReportingPanelPNGV2(r){if("canvas"===r.layoutOption)return(0,b.jsx)(_,(0,u.default)({requiresSavedState:!1,reportType:f.F,apiClient:e,layoutOption:"canvas",startServices$:t},r))}}}var x=r(1286);r(3721),r(4513);const j=e=>Boolean(e&&void 0!==(null==e?void 0:e.parentApi)),w=e=>Boolean(e&&void 0!==(null==e?void 0:e.viewMode$)),E=__kbnSharedDeps__.KbnEsQuery;var P=r(5228),C=r(1485),R=r(4839),T=r(5190),M=r(1663),k=r(1403),D=r(5879),O=r(3721);const A=e=>{return(e=>Boolean(e&&e.type))(e)&&((e,t)=>Boolean(e&&e.type)&&e.type===t)(e,x.SEARCH_EMBEDDABLE_TYPE)&&(0,x.apiPublishesSavedSearch)(e)&&(e=>w(e)||j(e)&&w(e.parentApi))(e)&&Boolean(e.hasTimeRange)&&(t=e,Boolean(t&&void 0!==(null==t?void 0:t.title$)&&void 0!==(null==t?void 0:t.hideTitle$)));var t};class ReportingCsvPanelAction{constructor({core:e,csvConfig:t,apiClient:r,startServices$:s,usesUiCapabilities:n}){(0,a.default)(this,"isDownloading",void 0),(0,a.default)(this,"type",""),(0,a.default)(this,"id",C.By),(0,a.default)(this,"i18nStrings",void 0),(0,a.default)(this,"notifications",void 0),(0,a.default)(this,"apiClient",void 0),(0,a.default)(this,"enablePanelActionDownload",void 0),(0,a.default)(this,"usesUiCapabilities",void 0),(0,a.default)(this,"startServices$",void 0),(0,a.default)(this,"isCompatible",(async e=>{var t;const{embeddable:r}=e;if(!A(r))return!1;const[{application:a},{licensing:s}]=await(0,i.firstValueFrom)(this.startServices$),o=await(0,i.firstValueFrom)(s.license$),n=(0,T.q)(o.check("reporting","basic")).showLinks,l=!this.usesUiCapabilities||!0===(null===(t=a.capabilities.dashboard)||void 0===t?void 0:t.downloadCsv);return!(!n||!l)&&"edit"!==(w(c=r)?c.viewMode$.getValue():j(c)&&w(c.parentApi)?c.parentApi.viewMode$.getValue():void 0);var c})),(0,a.default)(this,"executeDownload",(async e=>{const[{rendering:t}]=await(0,i.firstValueFrom)(this.startServices$),{searchSource:r,columns:a,title:s}=e,o=this.apiClient.getDecoratedJobParams({searchSource:r,columns:a,title:s,objectType:"downloadCsv"});this.isDownloading=!0,this.notifications.toasts.addSuccess({title:this.i18nStrings.download.toasts.success.title,text:(0,P.Pv)(this.i18nStrings.download.toasts.success.body,t),"data-test-subj":"csvDownloadStarted"}),await this.apiClient.createImmediateReport(o).then((({body:e,response:t})=>{this.isDownloading=!1;const r=`${s}.csv`,a=new Blob([e],{type:(null==t?void 0:t.headers.get("content-type"))||void 0});if(window.navigator.msSaveOrOpenBlob)return window.navigator.msSaveOrOpenBlob(a,r);const i=window.document.createElement("a"),o=window.URL.createObjectURL(a);i.href=o,i.download=r,document.body.appendChild(i),i.click(),window.URL.revokeObjectURL(o),document.body.removeChild(i)})).catch((e=>{O.error(e),this.isDownloading=!1,this.notifications.toasts.addDanger({title:this.i18nStrings.download.toasts.error.title,text:this.i18nStrings.download.toasts.error.body,"data-test-subj":"downloadCsvFail"})}))})),(0,a.default)(this,"executeGenerate",(async e=>{const[{rendering:t}]=await(0,i.firstValueFrom)(this.startServices$),{searchModeParams:r,title:a}=e,{reportType:s,decoratedJobParams:o}=(0,M.U)({apiClient:this.apiClient,searchModeParams:r,title:a});await this.apiClient.createReportingJob(s,o).then((e=>{e&&this.notifications.toasts.addSuccess({title:this.i18nStrings.generate.toasts.success.title,text:(0,P.Pv)(this.i18nStrings.generate.toasts.success.body,t),"data-test-subj":"csvReportStarted"})})).catch((e=>{O.error(e),this.notifications.toasts.addDanger({title:this.i18nStrings.generate.toasts.error.title,text:this.i18nStrings.generate.toasts.error.body,"data-test-subj":"generateCsvFail"})}))})),(0,a.default)(this,"getDiscoverLocatorParamsForEsqlCSV",((e,t,r)=>{var a,i;const s=null===(a=e.savedObjectId$)||void 0===a?void 0:a.getValue();return{...s?{savedSearchId:s}:{},query:t.query,filters:null===(i=t.parent)||void 0===i?void 0:i.filter,columns:r}})),(0,a.default)(this,"execute",(async e=>{var t;const{embeddable:r}=e;if(!A(r)||!await this.isCompatible(e))throw new R.IncompatibleActionError;const a=r.savedSearch$.getValue();if(!a||this.isDownloading)return;const i=null!==(t=r.title$.getValue())&&void 0!==t?t:"",{columns:s,getSearchSource:o}=await this.getSharingData(a),n=o({addGlobalTimeFilter:!r.hasTimeRange(),absoluteTime:!0});if(this.enablePanelActionDownload){const e={searchSource:n,columns:s,title:i,savedSearch:a};return this.executeDownload(e)}return this.isEsqlMode(a)?this.executeGenerate({title:i,searchModeParams:{isEsqlMode:!0,locatorParams:[{id:k.T,params:this.getDiscoverLocatorParamsForEsqlCSV(r,n,s)}]}}):this.executeGenerate({title:i,searchModeParams:{isEsqlMode:!1,searchSource:n,columns:s}})})),this.isDownloading=!1,this.apiClient=r,this.enablePanelActionDownload=!0===t.enablePanelActionDownload,this.notifications=e.notifications,this.startServices$=s,this.usesUiCapabilities=n,this.i18nStrings=(e=>({download:{displayName:o.i18n.translate("reporting.share.panelAction.downloadCsvPanelTitle",{defaultMessage:"Download CSV"}),toasts:{error:{title:o.i18n.translate("reporting.share.panelAction.failedCsvReportTitle",{defaultMessage:"CSV download failed"}),body:o.i18n.translate("reporting.share.panelAction.failedCsvReportMessage",{defaultMessage:"We couldn't download your CSV at this time."})},success:{title:o.i18n.translate("reporting.share.panelAction.csvDownloadStartedTitle",{defaultMessage:"CSV download started"}),body:(0,b.jsx)(D.FormattedMessage,{id:"reporting.share.panelAction.csvDownloadStartedMessage",defaultMessage:"Your CSV will download momentarily."})}}},generate:{displayName:o.i18n.translate("reporting.share.panelAction.generateCsvPanelTitle",{defaultMessage:"Generate CSV report"}),toasts:{error:{title:o.i18n.translate("reporting.share.panelAction.failedGenerateCsvReportTitle",{defaultMessage:"CSV report failed"}),body:o.i18n.translate("reporting.share.panelAction.failedGenerateCsvReportMessage",{defaultMessage:"We couldn't generate your CSV at this time."})},success:{title:o.i18n.translate("reporting.share.panelAction.csvReportStartedTitle",{defaultMessage:"Queued report for CSV"}),body:(0,b.jsx)(D.FormattedMessage,{id:"reporting.share.panelAction.successfullyQueuedReportNotificationDescription",defaultMessage:"Track its progress in {path}.",values:{path:(0,b.jsx)("a",{href:e.getManagementLink()},(0,b.jsx)(D.FormattedMessage,{id:"reporting.share.panelAction.reportLink.reportingSectionUrlLinkLabel",defaultMessage:"Stack Management > Reporting"}))}})}}}}))(r)}getIconType(){return"document"}getDisplayName(){return this.enablePanelActionDownload?this.i18nStrings.download.displayName:this.i18nStrings.generate.displayName}async getSharingData(e){const[{uiSettings:t},{data:r}]=await(0,i.firstValueFrom)(this.startServices$),{getSharingData:a}=await(0,x.loadSharingDataHelpers)();return await a(e.searchSource,e,{uiSettings:t,data:r},this.isEsqlMode(e))}isEsqlMode(e){return(0,E.isOfAggregateQueryType)(e.searchSource.getField("query"))}}var I=r(7023),F=r(7885);const L=(e,t,r,a,i)=>({title:(0,P.Pv)((0,b.jsx)(D.FormattedMessage,{id:"xpack.reporting.publicNotifier.error.couldNotCreateReportTitle",defaultMessage:"Cannot create {reportType} report for ''{reportObjectTitle}''.",values:{reportType:t.jobtype,reportObjectTitle:t.title}}),i),text:(0,P.Pv)((0,b.jsx)(g().Fragment,null,(0,b.jsx)(m.EuiCallOut,{size:"m",color:"danger","data-test-errorText":e},t.errorCode===I.zf.code?F.u.cloud.insufficientMemoryError(a.links.reporting.cloudMinimumRequirements):e),(0,b.jsx)(m.EuiSpacer,null),(0,b.jsx)("p",null,(0,b.jsx)(D.FormattedMessage,{id:"xpack.reporting.publicNotifier.error.checkManagement",defaultMessage:"Go to {path} for details.",values:{path:(0,b.jsx)("a",{href:r()},(0,b.jsx)(D.FormattedMessage,{id:"xpack.reporting.publicNotifier.error.reportingSectionUrlLinkLabel",defaultMessage:"Stack Management > Kibana > Reporting"}))}}))),i),iconType:void 0,"data-test-subj":"completeReportFailure"}),N=(e,t,r)=>({text:(0,P.Pv)((0,b.jsx)(g().Fragment,null,(0,b.jsx)(m.EuiCallOut,{title:e,color:"danger",iconType:"warning"},t.toString()),(0,b.jsx)(m.EuiSpacer,null),(0,b.jsx)(D.FormattedMessage,{id:"xpack.reporting.publicNotifier.error.tryRefresh",defaultMessage:"Try refreshing the page."})),r),iconType:void 0}),U=({getUrl:e,job:t})=>(0,b.jsx)(m.EuiButton,{size:"s","data-test-subj":"downloadCompletedReportButton","data-test-jobId":t.id,href:e(t.id),target:"_blank"},(0,b.jsx)(D.FormattedMessage,{id:"xpack.reporting.publicNotifier.downloadReportButtonLabel",defaultMessage:"Download report"})),$=({getUrl:e})=>(0,b.jsx)(D.FormattedMessage,{id:"xpack.reporting.publicNotifier.reportLinkDescription",defaultMessage:"Download it now, or get it later in {path}.",values:{path:(0,b.jsx)("a",{href:e()},(0,b.jsx)(D.FormattedMessage,{id:"xpack.reporting.publicNotifier.reportLink.reportingSectionUrlLinkLabel",defaultMessage:"Stack Management > Reporting"}))}}),B=(e,t,r,a)=>({title:(0,P.Pv)((0,b.jsx)(D.FormattedMessage,{id:"xpack.reporting.publicNotifier.successfullyCreatedReportNotificationTitle",defaultMessage:"{reportType} created for ''{reportObjectTitle}''",values:{reportType:e.jobtype,reportObjectTitle:e.title}}),a),color:"success",text:(0,P.Pv)((0,b.jsx)(g().Fragment,null,(0,b.jsx)("p",null,(0,b.jsx)($,{getUrl:t})),(0,b.jsx)(U,{getUrl:r,job:e})),a),"data-test-subj":"completeReportSuccess"}),J=(e,t,r,a)=>({title:(0,P.Pv)((0,b.jsx)(D.FormattedMessage,{id:"xpack.reporting.publicNotifier.csvContainsFormulas.formulaReportTitle",defaultMessage:"{reportType} may contain formulas",values:{reportType:e.jobtype}}),a),text:(0,P.Pv)((0,b.jsx)(g().Fragment,null,(0,b.jsx)("p",null,(0,b.jsx)(D.FormattedMessage,{id:"xpack.reporting.publicNotifier.csvContainsFormulas.formulaReportMessage",defaultMessage:"The report ''{reportObjectTitle}'' contains characters which spreadsheet applications can interpret as formulas.",values:{reportObjectTitle:e.title}})),(0,b.jsx)("p",null,(0,b.jsx)($,{getUrl:t})),(0,b.jsx)(U,{getUrl:r,job:e})),a),"data-test-subj":"completeReportCsvFormulasWarning"}),V=(e,t,r,a)=>({title:(0,P.Pv)((0,b.jsx)(D.FormattedMessage,{id:"xpack.reporting.publicNotifier.maxSizeReached.partialReportTitle",defaultMessage:"Created partial {reportType} for ''{reportObjectTitle}''",values:{reportType:e.jobtype,reportObjectTitle:e.title}}),a),text:(0,P.Pv)((0,b.jsx)(g().Fragment,null,(0,b.jsx)("p",null,(0,b.jsx)(D.FormattedMessage,{id:"xpack.reporting.publicNotifier.maxSizeReached.partialReportDescription",defaultMessage:"The report reached the max size and contains partial data."})),(0,b.jsx)("p",null,(0,b.jsx)($,{getUrl:t})),(0,b.jsx)(U,{getUrl:r,job:e})),a),"data-test-subj":"completeReportMaxSizeWarning"}),G=(e,t,r,a)=>({title:(0,P.Pv)((0,b.jsx)(D.FormattedMessage,{id:"xpack.reporting.publicNotifier.warning.title",defaultMessage:"{reportType} completed with issues",values:{reportType:e.jobtype}}),a),text:(0,P.Pv)((0,b.jsx)(g().Fragment,null,(0,b.jsx)("p",null,(0,b.jsx)($,{getUrl:t})),(0,b.jsx)(U,{getUrl:r,job:e})),a),"data-test-subj":"completeReportWarning"});var z=r(3721);function q(e){var t;return{id:e.id,status:e.status,title:e.title,jobtype:null!==(t=e.prettyJobTypeName)&&void 0!==t?t:e.jobtype,maxSizeReached:e.max_size_reached,csvContainsFormulas:e.csv_contains_formulas,errorCode:e.error_code}}class ReportingNotifierStreamHandler{constructor(e,t){(0,a.default)(this,"jobCompletionNotifications",(0,l.jobCompletionNotifications)()),this.apiClient=e,this.core=t}startPolling(e,t){i.timer(0,e).pipe((0,i.takeUntil)(t),(0,i.map)(this.jobCompletionNotifications.getPendingJobIds),(0,i.filter)((e=>e.length>0)),(0,i.mergeMap)((e=>this.findChangedStatusJobs(e))),(0,i.mergeMap)((({completed:e,failed:t})=>this.showNotifications({completed:e,failed:t}))),(0,i.catchError)((e=>(z.error(e),function(e,t){return e.notifications.toasts.addDanger(N(o.i18n.translate("xpack.reporting.publicNotifier.pollingErrorMessage",{defaultMessage:"Reporting notifier error!"}),t,e)),window.console.error(t),i.of({completed:[],failed:[]})}(this.core,e))))).subscribe()}showNotifications({completed:e,failed:t}){const r=this.core.notifications,a=this.apiClient,s=this.core,o=this.core.docLinks,l=a.getManagementLink.bind(a),c=a.getDownloadLink.bind(a);return i.from((async()=>{const i={toastLifeTimeMs:864e5};for(const t of null!=e?e:[])t.csvContainsFormulas?r.toasts.addWarning(J(t,l,c,s),i):t.maxSizeReached?r.toasts.addWarning(V(t,l,c,s),i):t.status===n.Pm.WARNINGS?r.toasts.addWarning(G(t,l,c,s),i):r.toasts.addSuccess(B(t,l,c,s),i);for(const e of null!=t?t:[]){const t=await a.getError(e.id);r.toasts.addDanger(L(t,e,l,o,s))}return{completed:e,failed:t}})())}findChangedStatusJobs(e){return i.from(this.apiClient.findForJobIds(e)).pipe((0,i.mergeMap)((async t=>{const r=[],a=[],i=[];for(const s of e){const e=t.find((({id:e})=>e===s));(null==e?void 0:e.status)===n.Pm.COMPLETED||(null==e?void 0:e.status)===n.Pm.WARNINGS?r.push(q(e)):(null==e?void 0:e.status)===n.Pm.FAILED?a.push(q(e)):i.push(s)}return this.jobCompletionNotifications.setPendingJobIds(i),{completed:r,failed:a}})),(0,i.catchError)((e=>(this.core.notifications.toasts.addDanger(N(o.i18n.translate("xpack.reporting.publicNotifier.httpErrorMessage",{defaultMessage:"Could not check Reporting job status!"}),e,this.core)),window.console.error(e),i.of({})))))}}var W=r(7808),K=r(4023);class ReportingPublicPlugin{constructor(e){(0,a.default)(this,"kibanaVersion",void 0),(0,a.default)(this,"apiClient",void 0),(0,a.default)(this,"stop$",new i.ReplaySubject(1)),(0,a.default)(this,"title",o.i18n.translate("xpack.reporting.management.reportingTitle",{defaultMessage:"Reporting"})),(0,a.default)(this,"breadcrumbText",o.i18n.translate("xpack.reporting.breadcrumb",{defaultMessage:"Reporting"})),(0,a.default)(this,"config",void 0),(0,a.default)(this,"contract",void 0),(0,a.default)(this,"startServices$",void 0),this.config=e.config.get(),this.kibanaVersion=e.env.packageInfo.version}getContract(e,t){if(this.contract={usesUiCapabilities:()=>{var e;return!1===(null===(e=this.config.roles)||void 0===e?void 0:e.enabled)},components:S(e,t)},!this.contract)throw new Error("Setup error in Reporting plugin!");return this.contract}setup(e,t){const{getStartServices:a}=e,{home:o,management:n,screenshotMode:u,share:p,uiActions:g,actions:h}=t,f=(0,i.from)(a()).pipe((0,i.map)((([e,...t])=>[{application:e.application,notifications:e.notifications,rendering:e.rendering,uiSettings:e.uiSettings,chrome:e.chrome},...t]))),m=!this.config.roles.enabled,b=new l.ReportingAPIClient(e.http,e.uiSettings,this.kibanaVersion);return this.apiClient=b,o.featureCatalogue.register({id:"reporting",title:W.B_,description:W.Un,icon:"reportingApp",path:K.y1,showOnHomePage:!1,category:"admin"}),n.sections.section.insightsAndAlerting.registerApp({id:"reporting",title:this.title,order:3,keywords:["reports","report","reporting"],mount:async e=>{e.setBreadcrumbs([{text:this.breadcrumbText}]);const[[t,i],{mountManagementSection:s}]=await Promise.all([a(),r.e(640).then(r.bind(r,8640))]),{licensing:o,data:n,share:l}=i,{docTitle:c}=t.chrome;c.change(this.title);const d=await s({coreStart:t,license$:o.license$,dataService:n,shareService:l,config:this.config,apiClient:b,params:e,actionsService:h,notificationsService:t.notifications});return()=>{c.reset(),d()}}}),e.application.register({id:"reportingRedirect",mount:async t=>{const[a,i]=await Promise.all([e.getStartServices(),r.e(926).then(r.bind(r,5926))]),[s]=a,{mountRedirectApp:o}=i;return o(s,{...t,apiClient:b,screenshotMode:u,share:p})},title:"Reporting redirect app",chromeless:!0,exactRoute:!0,visibleIn:[]}),g.addTriggerAction(s.CONTEXT_MENU_TRIGGER,new ReportingCsvPanelAction({core:e,apiClient:b,startServices$:f,usesUiCapabilities:m,csvConfig:this.config.csv})),p.registerShareIntegration("search",(0,d.u)({apiClient:b,startServices$:f,usesUiCapabilities:m})),(this.config.export_types.pdf.enabled||this.config.export_types.png.enabled)&&(p.registerShareIntegration((0,c.af)({apiClient:b,startServices$:f,usesUiCapabilities:m})),p.registerShareIntegration((0,c.TG)({apiClient:b,startServices$:f,usesUiCapabilities:m}))),Promise.all([r.e(86),r.e(110)]).then(r.bind(r,5110)).then((async({shouldRegisterScheduledReportShareIntegration:t,createScheduledReportShareIntegration:r})=>{const[i,s]=await a();await t(e.http)&&p.registerShareIntegration(r({apiClient:b,services:{...i,...s,actions:h}}))})),this.startServices$=f,this.getContract(b,f)}start(e){const t=new ReportingNotifierStreamHandler(this.apiClient,e),r=(0,n.l6)(this.config.poll.jobsRefresh.interval);return t.startPolling(r,this.stop$),this.getContract(this.apiClient,this.startServices$)}stop(){this.stop$.next()}}function H(e){return new ReportingPublicPlugin(e)}},7885:(e,t,r)=>{"use strict";r.d(t,{u:()=>n}),r(4286);var a=r(5008),i=r(5879),s=r(1319),o=r(6791);const n={cloud:{insufficientMemoryError:e=>(0,o.jsx)(i.FormattedMessage,{id:"xpack.reporting.listing.infoPanel.callout.cloud.insufficientMemoryError",defaultMessage:"Kibana needs more memory to generate this report. Check {link}.",values:{link:(0,o.jsx)(s.EuiLink,{href:e},a.i18n.translate("xpack.reporting.listing.infoPanel.callout.cloud.insufficientMemoryError.urlLink",{defaultMessage:"RAM requirements"}))}})}}},7808:(e,t,r)=>{"use strict";r.d(t,{B_:()=>i,Q3:()=>o,Un:()=>s});var a=r(5008);const i=a.i18n.translate("xpack.reporting.registerFeature.reportingTitle",{defaultMessage:"Reporting"}),s=a.i18n.translate("xpack.reporting.registerFeature.reportingDescription",{defaultMessage:"Manage your reports generated from Discover, Visualize, and Dashboard."}),o=(a.i18n.translate("xpack.reporting.table.loadingReportsDescription",{defaultMessage:"Loading reports"}),a.i18n.translate("xpack.reporting.table.noCreatedReportsDescription",{defaultMessage:"No reports have been created"}))},6214:e=>{"use strict";var t="%[a-f0-9]{2}",r=new RegExp("("+t+")|([^%]+?)","gi"),a=new RegExp("("+t+")+","gi");function i(e,t){try{return[decodeURIComponent(e.join(""))]}catch(e){}if(1===e.length)return e;t=t||1;var r=e.slice(0,t),a=e.slice(t);return Array.prototype.concat.call([],i(r),i(a))}function s(e){try{return decodeURIComponent(e)}catch(s){for(var t=e.match(r)||[],a=1;a<t.length;a++)t=(e=i(t,a).join("")).match(r)||[];return e}}e.exports=function(e){if("string"!=typeof e)throw new TypeError("Expected `encodedURI` to be of type `string`, got `"+typeof e+"`");try{return e=e.replace(/\+/g," "),decodeURIComponent(e)}catch(t){return function(e){for(var t={"%FE%FF":"��","%FF%FE":"��"},r=a.exec(e);r;){try{t[r[0]]=decodeURIComponent(r[0])}catch(e){var i=s(r[0]);i!==r[0]&&(t[r[0]]=i)}r=a.exec(e)}t["%C2"]="�";for(var o=Object.keys(t),n=0;n<o.length;n++){var l=o[n];e=e.replace(new RegExp(l,"g"),t[l])}return e}(e)}}},4513:e=>{"use strict";e.exports=function e(t,r){if(t===r)return!0;if(t&&r&&"object"==typeof t&&"object"==typeof r){if(t.constructor!==r.constructor)return!1;var a,i,s;if(Array.isArray(t)){if((a=t.length)!=r.length)return!1;for(i=a;0!==i--;)if(!e(t[i],r[i]))return!1;return!0}if(t.constructor===RegExp)return t.source===r.source&&t.flags===r.flags;if(t.valueOf!==Object.prototype.valueOf)return t.valueOf()===r.valueOf();if(t.toString!==Object.prototype.toString)return t.toString()===r.toString();if((a=(s=Object.keys(t)).length)!==Object.keys(r).length)return!1;for(i=a;0!==i--;)if(!Object.prototype.hasOwnProperty.call(r,s[i]))return!1;for(i=a;0!==i--;){var o=s[i];if(!e(t[o],r[o]))return!1}return!0}return t!=t&&r!=r}},151:(e,t,r)=>{"use strict";const a=r(8136),i=r(6214),s=r(1536);function o(e){if("string"!=typeof e||1!==e.length)throw new TypeError("arrayFormatSeparator must be single character string")}function n(e,t){return t.encode?t.strict?a(e):encodeURIComponent(e):e}function l(e,t){return t.decode?i(e):e}function c(e){return Array.isArray(e)?e.sort():"object"==typeof e?c(Object.keys(e)).sort(((e,t)=>Number(e)-Number(t))).map((t=>e[t])):e}function d(e){const t=e.indexOf("#");return-1!==t&&(e=e.slice(0,t)),e}function u(e){const t=(e=d(e)).indexOf("?");return-1===t?"":e.slice(t+1)}function p(e,t){return t.parseNumbers&&!Number.isNaN(Number(e))&&"string"==typeof e&&""!==e.trim()?e=Number(e):!t.parseBooleans||null===e||"true"!==e.toLowerCase()&&"false"!==e.toLowerCase()||(e="true"===e.toLowerCase()),e}function g(e,t){o((t=Object.assign({decode:!0,sort:!0,arrayFormat:"none",arrayFormatSeparator:",",parseNumbers:!1,parseBooleans:!1},t)).arrayFormatSeparator);const r=function(e){let t;switch(e.arrayFormat){case"index":return(e,r,a)=>{t=/\[(\d*)\]$/.exec(e),e=e.replace(/\[\d*\]$/,""),t?(void 0===a[e]&&(a[e]={}),a[e][t[1]]=r):a[e]=r};case"bracket":return(e,r,a)=>{t=/(\[\])$/.exec(e),e=e.replace(/\[\]$/,""),t?void 0!==a[e]?a[e]=[].concat(a[e],r):a[e]=[r]:a[e]=r};case"comma":case"separator":return(t,r,a)=>{const i="string"==typeof r&&r.split("").indexOf(e.arrayFormatSeparator)>-1?r.split(e.arrayFormatSeparator).map((t=>l(t,e))):null===r?r:l(r,e);a[t]=i};default:return(e,t,r)=>{void 0!==r[e]?r[e]=[].concat(r[e],t):r[e]=t}}}(t),a=Object.create(null);if("string"!=typeof e)return a;if(!(e=e.trim().replace(/^[?#&]/,"")))return a;for(const i of e.split("&")){let[e,o]=s(t.decode?i.replace(/\+/g," "):i,"=");o=void 0===o?null:["comma","separator"].includes(t.arrayFormat)?o:l(o,t),r(l(e,t),o,a)}for(const e of Object.keys(a)){const r=a[e];if("object"==typeof r&&null!==r)for(const e of Object.keys(r))r[e]=p(r[e],t);else a[e]=p(r,t)}return!1===t.sort?a:(!0===t.sort?Object.keys(a).sort():Object.keys(a).sort(t.sort)).reduce(((e,t)=>{const r=a[t];return Boolean(r)&&"object"==typeof r&&!Array.isArray(r)?e[t]=c(r):e[t]=r,e}),Object.create(null))}t.extract=u,t.parse=g,t.stringify=(e,t)=>{if(!e)return"";o((t=Object.assign({encode:!0,strict:!0,arrayFormat:"none",arrayFormatSeparator:","},t)).arrayFormatSeparator);const r=r=>t.skipNull&&null==e[r]||t.skipEmptyString&&""===e[r],a=function(e){switch(e.arrayFormat){case"index":return t=>(r,a)=>{const i=r.length;return void 0===a||e.skipNull&&null===a||e.skipEmptyString&&""===a?r:null===a?[...r,[n(t,e),"[",i,"]"].join("")]:[...r,[n(t,e),"[",n(i,e),"]=",n(a,e)].join("")]};case"bracket":return t=>(r,a)=>void 0===a||e.skipNull&&null===a||e.skipEmptyString&&""===a?r:null===a?[...r,[n(t,e),"[]"].join("")]:[...r,[n(t,e),"[]=",n(a,e)].join("")];case"comma":case"separator":return t=>(r,a)=>null==a||0===a.length?r:0===r.length?[[n(t,e),"=",n(a,e)].join("")]:[[r,n(a,e)].join(e.arrayFormatSeparator)];default:return t=>(r,a)=>void 0===a||e.skipNull&&null===a||e.skipEmptyString&&""===a?r:null===a?[...r,n(t,e)]:[...r,[n(t,e),"=",n(a,e)].join("")]}}(t),i={};for(const t of Object.keys(e))r(t)||(i[t]=e[t]);const s=Object.keys(i);return!1!==t.sort&&s.sort(t.sort),s.map((r=>{const i=e[r];return void 0===i?"":null===i?n(r,t):Array.isArray(i)?i.reduce(a(r),[]).join("&"):n(r,t)+"="+n(i,t)})).filter((e=>e.length>0)).join("&")},t.parseUrl=(e,t)=>{t=Object.assign({decode:!0},t);const[r,a]=s(e,"#");return Object.assign({url:r.split("?")[0]||"",query:g(u(e),t)},t&&t.parseFragmentIdentifier&&a?{fragmentIdentifier:l(a,t)}:{})},t.stringifyUrl=(e,r)=>{r=Object.assign({encode:!0,strict:!0},r);const a=d(e.url).split("?")[0]||"",i=t.extract(e.url),s=t.parse(i,{sort:!1}),o=Object.assign(s,e.query);let l=t.stringify(o,r);l&&(l=`?${l}`);let c=function(e){let t="";const r=e.indexOf("#");return-1!==r&&(t=e.slice(r)),t}(e.url);return e.fragmentIdentifier&&(c=`#${n(e.fragmentIdentifier,r)}`),`${a}${l}${c}`}},1536:e=>{"use strict";e.exports=(e,t)=>{if("string"!=typeof e||"string"!=typeof t)throw new TypeError("Expected the arguments to be of type `string`");if(""===t)return[e];const r=e.indexOf(t);return-1===r?[e]:[e.slice(0,r),e.slice(r+t.length)]}},8136:e=>{"use strict";e.exports=e=>encodeURIComponent(e).replace(/[!'()*]/g,(e=>`%${e.charCodeAt(0).toString(16).toUpperCase()}`))},641:(e,t,r)=>{r.p=window.__kbnPublicPath__.reporting},6728:(e,t,r)=>{r.r(t);var a=__kbnBundles__.get("plugin/actions/common");Object.defineProperties(t,Object.getOwnPropertyDescriptors(a))},1286:(e,t,r)=>{r.r(t);var a=__kbnBundles__.get("plugin/discover/public");Object.defineProperties(t,Object.getOwnPropertyDescriptors(a))},7546:(e,t,r)=>{r.r(t);var a=__kbnBundles__.get("plugin/embeddable/public");Object.defineProperties(t,Object.getOwnPropertyDescriptors(a))},8744:(e,t,r)=>{r.r(t);var a=__kbnBundles__.get("plugin/esUiShared/public");Object.defineProperties(t,Object.getOwnPropertyDescriptors(a))},5296:(e,t,r)=>{r.r(t);var a=__kbnBundles__.get("plugin/esUiShared/static/forms/components");Object.defineProperties(t,Object.getOwnPropertyDescriptors(a))},791:(e,t,r)=>{r.r(t);var a=__kbnBundles__.get("plugin/esUiShared/static/forms/helpers");Object.defineProperties(t,Object.getOwnPropertyDescriptors(a))},2602:(e,t,r)=>{r.r(t);var a=__kbnBundles__.get("plugin/esUiShared/static/forms/hook_form_lib");Object.defineProperties(t,Object.getOwnPropertyDescriptors(a))},409:(e,t,r)=>{r.r(t);var a=__kbnBundles__.get("plugin/kibanaReact/public");Object.defineProperties(t,Object.getOwnPropertyDescriptors(a))},7888:(e,t,r)=>{r.r(t);var a=__kbnBundles__.get("plugin/share/public");Object.defineProperties(t,Object.getOwnPropertyDescriptors(a))},4839:(e,t,r)=>{r.r(t);var a=__kbnBundles__.get("plugin/uiActions/public");Object.defineProperties(t,Object.getOwnPropertyDescriptors(a))},3721:(e,t,r)=>{e.exports=r(2497)(4971)},3185:(e,t,r)=>{e.exports=r(2497)(51858)},8915:(e,t,r)=>{e.exports=r(2497)(67493)},1319:e=>{"use strict";e.exports=__kbnSharedDeps__.ElasticEui},6791:e=>{"use strict";e.exports=__kbnSharedDeps__.EmotionReact},5008:e=>{"use strict";e.exports=__kbnSharedDeps__.KbnI18n},5879:e=>{"use strict";e.exports=__kbnSharedDeps__.KbnI18nReact},482:e=>{"use strict";e.exports=__kbnSharedDeps__.KbnReactKibanaContextRender},5995:e=>{"use strict";e.exports=__kbnSharedDeps__.KbnRison},193:e=>{"use strict";e.exports=__kbnSharedDeps__.KbnSharedUxRouter},770:e=>{"use strict";e.exports=__kbnSharedDeps__.Lodash},1783:e=>{"use strict";e.exports=__kbnSharedDeps__.Moment},2488:e=>{"use strict";e.exports=__kbnSharedDeps__.MomentTimezone},4286:e=>{"use strict";e.exports=__kbnSharedDeps__.React},2874:e=>{"use strict";e.exports=__kbnSharedDeps__.ReactDom},3530:e=>{"use strict";e.exports=__kbnSharedDeps__.ReactQuery},1493:e=>{"use strict";e.exports=__kbnSharedDeps__.ReactRouterDom},190:e=>{"use strict";e.exports=__kbnSharedDeps__.Rxjs},1941:e=>{"use strict";e.exports=__kbnSharedDeps__.TsLib},2497:e=>{"use strict";e.exports=__kbnSharedDeps_npm__}},r={};function a(e){var i=r[e];if(void 0!==i)return i.exports;var s=r[e]={id:e,loaded:!1,exports:{}};return t[e](s,s.exports,a),s.loaded=!0,s.exports}a.m=t,a.n=e=>{var t=e&&e.__esModule?()=>e.default:()=>e;return a.d(t,{a:t}),t},a.d=(e,t)=>{for(var r in t)a.o(t,r)&&!a.o(e,r)&&Object.defineProperty(e,r,{enumerable:!0,get:t[r]})},a.f={},a.e=e=>Promise.all(Object.keys(a.f).reduce(((t,r)=>(a.f[r](e,t),t)),[])),a.u=e=>"reporting.chunk."+e+".js",a.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(e){if("object"==typeof window)return window}}(),a.o=(e,t)=>Object.prototype.hasOwnProperty.call(e,t),e={},a.l=(t,r,i,s)=>{if(e[t])e[t].push(r);else{var o,n;if(void 0!==i)for(var l=document.getElementsByTagName("script"),c=0;c<l.length;c++){var d=l[c];if(d.getAttribute("src")==t){o=d;break}}o||(n=!0,(o=document.createElement("script")).charset="utf-8",o.timeout=120,a.nc&&o.setAttribute("nonce",a.nc),o.src=t),e[t]=[r];var u=(r,a)=>{o.onerror=o.onload=null,clearTimeout(p);var i=e[t];if(delete e[t],o.parentNode&&o.parentNode.removeChild(o),i&&i.forEach((e=>e(a))),r)return r(a)},p=setTimeout(u.bind(null,void 0,{type:"timeout",target:o}),12e4);o.onerror=u.bind(null,o.onerror),o.onload=u.bind(null,o.onload),n&&document.head.appendChild(o)}},a.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},a.nmd=e=>(e.paths=[],e.children||(e.children=[]),e),(()=>{var e;a.g.importScripts&&(e=a.g.location+"");var t=a.g.document;if(!e&&t&&(t.currentScript&&"SCRIPT"===t.currentScript.tagName.toUpperCase()&&(e=t.currentScript.src),!e)){var r=t.getElementsByTagName("script");if(r.length)for(var i=r.length-1;i>-1&&(!e||!/^http(s?):/.test(e));)e=r[i--].src}if(!e)throw new Error("Automatic publicPath is not supported in this browser");e=e.replace(/#.*$/,"").replace(/\?.*$/,"").replace(/\/[^\/]+$/,"/"),a.p=e})(),(()=>{var e={951:0};a.f.j=(t,r)=>{var i=a.o(e,t)?e[t]:void 0;if(0!==i)if(i)r.push(i[2]);else{var s=new Promise(((r,a)=>i=e[t]=[r,a]));r.push(i[2]=s);var o=a.p+a.u(t),n=new Error;a.l(o,(r=>{if(a.o(e,t)&&(0!==(i=e[t])&&(e[t]=void 0),i)){var s=r&&("load"===r.type?"missing":r.type),o=r&&r.target&&r.target.src;n.message="Loading chunk "+t+" failed.\n("+s+": "+o+")",n.name="ChunkLoadError",n.type=s,n.request=o,i[1](n)}}),"chunk-"+t,t)}};var t=(t,r)=>{var i,s,[o,n,l]=r,c=0;if(o.some((t=>0!==e[t]))){for(i in n)a.o(n,i)&&(a.m[i]=n[i]);l&&l(a)}for(t&&t(r);c<o.length;c++)s=o[c],a.o(e,s)&&e[s]&&e[s][0](),e[s]=0},r=self.reporting_bundle_jsonpfunction=self.reporting_bundle_jsonpfunction||[];r.forEach(t.bind(null,0)),r.push=t.bind(null,r.push.bind(r))})(),a.nc=void 0,a(641),__kbnBundles__.define("plugin/reporting/public",a,8831)})();