"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.supportedReportTypes = exports.getReportParams = void 0;
var _rison = _interopRequireDefault(require("@kbn/rison"));
var _register_pdf_png_modal_reporting = require("@kbn/reporting-public/share/share_context_menu/register_pdf_png_modal_reporting");
var _register_csv_modal_reporting = require("@kbn/reporting-public/share/share_context_menu/register_csv_modal_reporting");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const reportParamsProviders = {
  pngV2: _register_pdf_png_modal_reporting.getPngReportParams,
  printablePdfV2: _register_pdf_png_modal_reporting.getPdfReportParams,
  csv_searchsource: _register_csv_modal_reporting.getCsvReportParams,
  csv_v2: _register_csv_modal_reporting.getCsvReportParams
};
const supportedReportTypes = exports.supportedReportTypes = Object.keys(reportParamsProviders);
const getReportParams = ({
  apiClient,
  reportTypeId,
  objectType,
  sharingData,
  title
}) => {
  const getParams = reportParamsProviders[reportTypeId];
  if (!getParams) {
    throw new Error(`No params provider found for report type ${reportTypeId}`);
  }
  return _rison.default.encode(apiClient.getDecoratedJobParams({
    ...getParams({
      objectType,
      sharingData
    }),
    objectType,
    title
  }));
};
exports.getReportParams = getReportParams;