"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getReportingHealth = void 0;
var _reportingCommon = require("@kbn/reporting-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getReportingHealth = async ({
  http
}) => {
  const res = await http.get(_reportingCommon.INTERNAL_ROUTES.HEALTH);
  return {
    isSufficientlySecure: res.is_sufficiently_secure,
    hasPermanentEncryptionKey: res.has_permanent_encryption_key,
    areNotificationsEnabled: res.are_notifications_enabled
  };
};
exports.getReportingHealth = getReportingHealth;