"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemoteClusterPageTitle = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _documentation = require("../../../services/documentation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RemoteClusterPageTitle = ({
  title,
  description
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
  bottomBorder: true,
  pageTitle: /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "remoteClusterPageTitle"
  }, title),
  rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    flush: "right",
    href: _documentation.remoteClustersUrl,
    target: "_blank",
    iconType: "question",
    "data-test-subj": "remoteClusterDocsButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.remoteClusters.readDocsButtonLabel",
    defaultMessage: "Remote cluster docs"
  }))],
  description: description
}), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "l"
}));
exports.RemoteClusterPageTitle = RemoteClusterPageTitle;