"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateSeed = validateSeed;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _validate_address = require("./validate_address");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function validateSeed(seed) {
  const errors = [];
  if (!seed) {
    return errors;
  }
  const isValid = (0, _validate_address.isAddressValid)(seed);
  if (!isValid) {
    errors.push(/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.localSeedError.invalidCharactersMessage",
      defaultMessage: "Seed node must use host:port format. Example: 127.0.0.1:9400, localhost:9400. Hosts can only consist of letters, numbers, and dashes."
    }));
  }
  if (!(0, _validate_address.isPortValid)(seed)) {
    errors.push(/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.localSeedError.invalidPortMessage",
      defaultMessage: "A port is required."
    }));
  }
  return errors;
}