"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isAddressValid = isAddressValid;
exports.isPortValid = isPortValid;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isAddressValid(seedNode) {
  if (!seedNode) {
    return false;
  }
  const portParts = seedNode.split(':');
  const parts = portParts[0].split('.');
  const containsInvalidCharacters = parts.some(part => {
    var _part$match;
    if (!part) {
      // no need to wait for regEx if the part is empty
      return true;
    }
    const [match] = (_part$match = part.match(/[A-Za-z0-9\-]*/)) !== null && _part$match !== void 0 ? _part$match : [];
    return match !== part;
  });
  return !containsInvalidCharacters;
}
function isPortValid(seedNode) {
  var _port$match;
  if (!seedNode) {
    return false;
  }
  const parts = seedNode.split(':');
  const hasOnePort = parts.length === 2;
  if (!hasOnePort) {
    return false;
  }
  const port = parts[1];
  if (!port) {
    return false;
  }
  const isPortNumeric = ((_port$match = port.match(/[0-9]*/)) !== null && _port$match !== void 0 ? _port$match : [])[0] === port;
  return isPortNumeric;
}