"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupSelfManaged = setupSelfManaged;
var _cluster_settings = require("../../lib/setup/cluster_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function setupSelfManaged({
  setupState,
  setupParams
}) {
  const executeFunctions = [...(setupState.resource_management.enabled ? [] : [_cluster_settings.enableResourceManagement]), ...(setupState.settings.configured ? [] : [_cluster_settings.setMaximumBuckets])];
  await Promise.all(executeFunctions.map(fn => fn(setupParams)));
}