"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IDLE_SOCKET_TIMEOUT = void 0;
exports.registerRoutes = registerRoutes;
var _apm = require("./apm");
var _flamechart = require("./flamechart");
var _functions = require("./functions");
var _route = require("./setup/route");
var _route2 = require("./storage_explorer/route");
var _topn = require("./topn");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IDLE_SOCKET_TIMEOUT = exports.IDLE_SOCKET_TIMEOUT = 5 * 60 * 1000; // 5 minutes

function registerRoutes(params) {
  (0, _flamechart.registerFlameChartSearchRoute)(params);
  (0, _functions.registerTopNFunctionsSearchRoute)(params);
  (0, _topn.registerTraceEventsTopNContainersSearchRoute)(params);
  (0, _topn.registerTraceEventsTopNDeploymentsSearchRoute)(params);
  (0, _topn.registerTraceEventsTopNHostsSearchRoute)(params);
  (0, _topn.registerTraceEventsTopNStackTracesSearchRoute)(params);
  (0, _topn.registerTraceEventsTopNThreadsSearchRoute)(params);
  // Setup of Profiling resources, automates the configuration of Universal Profiling
  // and will show instructions on how to add data
  (0, _route.registerSetupRoute)(params);
  (0, _route2.registerStorageExplorerRoute)(params);
  (0, _apm.registerTopNFunctionsAPMTransactionsRoute)(params);
}