"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataBreakdown = DataBreakdown;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _async_component = require("../../../components/async_component");
var _use_profiling_dependencies = require("../../../components/contexts/profiling_dependencies/use_profiling_dependencies");
var _use_time_range_async = require("../../../hooks/use_time_range_async");
var _grouped_index_details_chart = require("./grouped_index_details_chart");
var _grouped_index_details = require("./grouped_index_details");
var _storage_details_table = require("./storage_details_table");
var _use_profiling_params = require("../../../hooks/use_profiling_params");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DataBreakdown() {
  var _indicesStorageDetail, _indicesStorageDetail2, _indicesStorageDetail3;
  const theme = (0, _eui.useEuiTheme)();
  const {
    query
  } = (0, _use_profiling_params.useProfilingParams)('/storage-explorer');
  const {
    indexLifecyclePhase
  } = query;
  const {
    services: {
      fetchStorageExplorerIndicesStorageDetails
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const indicesStorageDetails = (0, _use_time_range_async.useTimeRangeAsync)(({
    http
  }) => {
    return fetchStorageExplorerIndicesStorageDetails({
      http,
      indexLifecyclePhase
    });
  }, [fetchStorageExplorerIndicesStorageDetails, indexLifecyclePhase]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.profiling.storageExplorer.dataBreakdown.title', {
    defaultMessage: 'Data breakdown'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_async_component.AsyncComponent, (0, _extends2.default)({
    size: "xl"
  }, indicesStorageDetails, {
    style: {
      height: 400
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_grouped_index_details_chart.GroupedIndexDetailsChart, {
    data: (_indicesStorageDetail = indicesStorageDetails.data) === null || _indicesStorageDetail === void 0 ? void 0 : _indicesStorageDetail.storageDetailsGroupedByIndex
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: theme.euiTheme.border.width.thin,
      backgroundColor: theme.euiTheme.border.color,
      marginLeft: 64,
      marginRight: 64
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_grouped_index_details.GroupedIndexDetails, {
    data: (_indicesStorageDetail2 = indicesStorageDetails.data) === null || _indicesStorageDetail2 === void 0 ? void 0 : _indicesStorageDetail2.storageDetailsGroupedByIndex
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_storage_details_table.StorageDetailsTable, {
    data: (_indicesStorageDetail3 = indicesStorageDetails.data) === null || _indicesStorageDetail3 === void 0 ? void 0 : _indicesStorageDetail3.storageDetailsPerIndex
  }))))));
}