"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapResult = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapResult = docHit => {
  var _docHit$highlight$con, _docHit$highlight;
  const content = docHit._source.content_body;
  return {
    title: docHit._source.content_title,
    content: typeof content === 'string' ? content : content.text,
    url: docHit._source.url,
    productName: docHit._source.product_name,
    highlights: (_docHit$highlight$con = (_docHit$highlight = docHit.highlight) === null || _docHit$highlight === void 0 ? void 0 : _docHit$highlight.content_body) !== null && _docHit$highlight$con !== void 0 ? _docHit$highlight$con : []
  };
};
exports.mapResult = mapResult;