"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContextTab = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _codeEditor = require("@kbn/code-editor");
var _constants = require("../../constants");
var _context = require("../../context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ContextTab = () => {
  const {
    store: {
      payload,
      validation
    },
    updatePayload,
    links
  } = (0, _context.useAppContext)();
  const {
    context,
    document,
    index,
    query
  } = payload;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.painlessLab.contextFieldTooltipText', {
        defaultMessage: 'Different contexts provide different functions on the ctx object'
      })
    }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.painlessLab.contextFieldLabel",
      defaultMessage: "Execution context"
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "question",
      color: "subdued"
    }))),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: links.painlessExecuteAPIContexts,
      target: "_blank"
    }, _i18n.i18n.translate('xpack.painlessLab.contextFieldDocLinkText', {
      defaultMessage: 'Context docs'
    }))),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    options: _constants.painlessContextOptions,
    valueOfSelected: context,
    onChange: nextContext => updatePayload({
      context: nextContext
    }),
    itemLayoutAlign: "top",
    hasDividers: true,
    fullWidth: true,
    "data-test-subj": "painlessContextDropDown"
  })), ['filter', 'score'].indexOf(context) !== -1 && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.painlessLab.indexFieldTooltipText', {
        defaultMessage: `Index mappings must be compatible with the sample document's fields`
      })
    }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.painlessLab.indexFieldLabel",
      defaultMessage: "Index name"
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "question",
      color: "subdued"
    }))),
    fullWidth: true,
    isInvalid: !validation.fields.index,
    error: validation.fields.index ? [] : [_i18n.i18n.translate('xpack.painlessLab.indexFieldMissingErrorMessage', {
      defaultMessage: 'Enter an index name'
    })]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    value: index || '',
    onChange: e => {
      const nextIndex = e.target.value;
      updatePayload({
        index: nextIndex
      });
    },
    isInvalid: !validation.fields.index
  })), 'score'.indexOf(context) !== -1 && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.painlessLab.queryFieldTooltipText', {
        defaultMessage: 'Use query to specify that that _score will be used to calculate score.'
      })
    }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.painlessLab.queryFieldLabel",
      defaultMessage: "Query"
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "question",
      color: "subdued"
    }))),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: links.esQueryDSL,
      target: "_blank"
    }, _i18n.i18n.translate('xpack.painlessLab.queryFieldDocLinkText', {
      defaultMessage: 'Query DSL docs'
    }))),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    languageId: "json",
    height: 150,
    value: query,
    onChange: nextQuery => updatePayload({
      query: nextQuery
    }),
    options: {
      fontSize: 12,
      minimap: {
        enabled: false
      },
      scrollBeyondLastLine: false,
      wordWrap: 'on',
      wrappingIndent: 'indent',
      automaticLayout: true
    }
  })), ['filter', 'score'].indexOf(context) !== -1 && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.painlessLab.documentFieldTooltipText', {
        defaultMessage: "Your script can access this document's fields"
      })
    }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.painlessLab.documentFieldLabel",
      defaultMessage: "Sample document (JSON)"
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "question",
      color: "subdued"
    }))),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    languageId: "json",
    height: 400,
    value: document,
    onChange: nextDocument => updatePayload({
      document: nextDocument
    }),
    options: {
      fontSize: 12,
      minimap: {
        enabled: false
      },
      scrollBeyondLastLine: false,
      wordWrap: 'on',
      wrappingIndent: 'indent',
      automaticLayout: true
    }
  })));
};
exports.ContextTab = ContextTab;