"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPackagePolicyDeleteCallback = void 0;
var _lodash = require("lodash");
var _common = require("@kbn/fleet-plugin/common");
var _types = require("../../common/types");
var _common2 = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPackagePolicyDeleteCallback = packsClient => async deletedPackagePolicy => {
  const deletedOsqueryManagerPolicies = (0, _lodash.filter)(deletedPackagePolicy, ['package.name', _common2.OSQUERY_INTEGRATION_NAME]);
  await Promise.all((0, _lodash.map)(deletedOsqueryManagerPolicies, async deletedOsqueryManagerPolicy => {
    var _deletedOsqueryManage;
    const policyIds = (_deletedOsqueryManage = deletedOsqueryManagerPolicy.policy_ids) !== null && _deletedOsqueryManage !== void 0 && _deletedOsqueryManage.length ? deletedOsqueryManagerPolicy.policy_ids : [deletedOsqueryManagerPolicy.policy_id];
    if (policyIds[0] !== undefined) {
      const foundPacks = await packsClient.find({
        type: _types.packSavedObjectType,
        hasReference: policyIds.map(policyId => ({
          type: _common.LEGACY_AGENT_POLICY_SAVED_OBJECT_TYPE,
          id: policyId
        })),
        perPage: 1000
      });
      await Promise.all((0, _lodash.map)(foundPacks.saved_objects, pack => packsClient.update(_types.packSavedObjectType, pack.id, {
        shards: (0, _lodash.filter)(pack.attributes.shards, shard => policyIds.includes(shard.key))
      }, {
        references: (0, _lodash.filter)(pack.references, reference => policyIds.includes(reference.id))
      })));
    }
  }));
};
exports.getPackagePolicyDeleteCallback = getPackagePolicyDeleteCallback;