"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.alertDetailsContextRt = exports.AlertDetailsContextualInsightsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var t = _interopRequireWildcard(require("io-ts"));
var _lodash = require("lodash");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const alertDetailsContextRt = exports.alertDetailsContextRt = t.intersection([t.type({
  alert_started_at: t.string
}), t.partial({
  // alert fields used for log rate analysis
  alert_rule_parameter_time_size: t.string,
  alert_rule_parameter_time_unit: t.string,
  // apm fields
  'service.name': t.string,
  'service.environment': t.string,
  'transaction.type': t.string,
  'transaction.name': t.string,
  // infrastructure fields
  'host.name': t.string,
  'container.id': t.string,
  'kubernetes.pod.name': t.string
})]);
class AlertDetailsContextualInsightsService {
  constructor() {
    (0, _defineProperty2.default)(this, "handlers", []);
  }
  registerHandler(handler) {
    this.handlers.push(handler);
  }
  async getAlertDetailsContext(context, query) {
    if (this.handlers.length === 0) {
      return [];
    }
    const results = await Promise.all(this.handlers.map(async handler => {
      try {
        return await handler(context, query);
      } catch (error) {
        console.error(`Error: Could not get alert context from handler`, error);
        return [];
      }
    }));
    return (0, _lodash.flatten)(results);
  }
}
exports.AlertDetailsContextualInsightsService = AlertDetailsContextualInsightsService;