"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isSuggestedDashboardsValidRuleTypeId = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SUGGESTED_DASHBOARDS_VALID_RULE_TYPE_IDS = [_ruleDataUtils.OBSERVABILITY_THRESHOLD_RULE_TYPE_ID];
const isSuggestedDashboardsValidRuleTypeId = ruleTypeId => {
  return ruleTypeId !== undefined && Object.values(SUGGESTED_DASHBOARDS_VALID_RULE_TYPE_IDS).includes(ruleTypeId);
};
exports.isSuggestedDashboardsValidRuleTypeId = isSuggestedDashboardsValidRuleTypeId;